<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BaseResponse
 * @subpackage Structs
 */
class BaseResponse extends AbstractStructBase
{
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $requestId;
    /**
     * The apnReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $apnReference;
    /**
     * The transactionState
     * @var string
     */
    public $transactionState;
    /**
     * Constructor method for BaseResponse
     * @uses BaseResponse::setRequestId()
     * @uses BaseResponse::setApnReference()
     * @uses BaseResponse::setTransactionState()
     * @param string $requestId
     * @param string $apnReference
     * @param string $transactionState
     */
    public function __construct($requestId = null, $apnReference = null, $transactionState = null)
    {
        $this
            ->setRequestId($requestId)
            ->setApnReference($apnReference)
            ->setTransactionState($transactionState);
    }
    /**
     * Get requestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param string $requestId
     * @return \StructType\BaseResponse
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get apnReference value
     * @return string|null
     */
    public function getApnReference()
    {
        return $this->apnReference;
    }
    /**
     * Set apnReference value
     * @param string $apnReference
     * @return \StructType\BaseResponse
     */
    public function setApnReference($apnReference = null)
    {
        // validation for constraint: string
        if (!is_null($apnReference) && !is_string($apnReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apnReference)), __LINE__);
        }
        $this->apnReference = $apnReference;
        return $this;
    }
    /**
     * Get transactionState value
     * @return string|null
     */
    public function getTransactionState()
    {
        return $this->transactionState;
    }
    /**
     * Set transactionState value
     * @uses \EnumType\TransactionState::valueIsValid()
     * @uses \EnumType\TransactionState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionState
     * @return \StructType\BaseResponse
     */
    public function setTransactionState($transactionState = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionState::valueIsValid($transactionState)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionState, implode(', ', \EnumType\TransactionState::getValidValues())), __LINE__);
        }
        $this->transactionState = $transactionState;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
