<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:authDetails
 * @subpackage Structs
 */
class AuthDetails extends AbstractStructBase
{
    /**
     * The authCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $authCode;
    /**
     * The amountInMinorUnits
     * @var int
     */
    public $amountInMinorUnits;
    /**
     * The maskedCardNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $maskedCardNumber;
    /**
     * The cardDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cardDescription;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cardType;
    /**
     * The merchantNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $merchantNumber;
    /**
     * The expiryDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $expiryDate;
    /**
     * The uniqueAuthId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $uniqueAuthId;
    /**
     * The cssCardType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cssCardType;
    /**
     * Constructor method for authDetails
     * @uses AuthDetails::setAuthCode()
     * @uses AuthDetails::setAmountInMinorUnits()
     * @uses AuthDetails::setMaskedCardNumber()
     * @uses AuthDetails::setCardDescription()
     * @uses AuthDetails::setCardType()
     * @uses AuthDetails::setMerchantNumber()
     * @uses AuthDetails::setExpiryDate()
     * @uses AuthDetails::setUniqueAuthId()
     * @uses AuthDetails::setCssCardType()
     * @param string $authCode
     * @param int $amountInMinorUnits
     * @param string $maskedCardNumber
     * @param string $cardDescription
     * @param string $cardType
     * @param string $merchantNumber
     * @param string $expiryDate
     * @param string $uniqueAuthId
     * @param string $cssCardType
     */
    public function __construct($authCode = null, $amountInMinorUnits = null, $maskedCardNumber = null, $cardDescription = null, $cardType = null, $merchantNumber = null, $expiryDate = null, $uniqueAuthId = null, $cssCardType = null)
    {
        $this
            ->setAuthCode($authCode)
            ->setAmountInMinorUnits($amountInMinorUnits)
            ->setMaskedCardNumber($maskedCardNumber)
            ->setCardDescription($cardDescription)
            ->setCardType($cardType)
            ->setMerchantNumber($merchantNumber)
            ->setExpiryDate($expiryDate)
            ->setUniqueAuthId($uniqueAuthId)
            ->setCssCardType($cssCardType);
    }
    /**
     * Get authCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->authCode;
    }
    /**
     * Set authCode value
     * @param string $authCode
     * @return \StructType\AuthDetails
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authCode)), __LINE__);
        }
        $this->authCode = $authCode;
        return $this;
    }
    /**
     * Get amountInMinorUnits value
     * @return int|null
     */
    public function getAmountInMinorUnits()
    {
        return $this->amountInMinorUnits;
    }
    /**
     * Set amountInMinorUnits value
     * @param int $amountInMinorUnits
     * @return \StructType\AuthDetails
     */
    public function setAmountInMinorUnits($amountInMinorUnits = null)
    {
        // validation for constraint: int
        if (!is_null($amountInMinorUnits) && !is_numeric($amountInMinorUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amountInMinorUnits)), __LINE__);
        }
        $this->amountInMinorUnits = $amountInMinorUnits;
        return $this;
    }
    /**
     * Get maskedCardNumber value
     * @return string|null
     */
    public function getMaskedCardNumber()
    {
        return $this->maskedCardNumber;
    }
    /**
     * Set maskedCardNumber value
     * @param string $maskedCardNumber
     * @return \StructType\AuthDetails
     */
    public function setMaskedCardNumber($maskedCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($maskedCardNumber) && !is_string($maskedCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maskedCardNumber)), __LINE__);
        }
        $this->maskedCardNumber = $maskedCardNumber;
        return $this;
    }
    /**
     * Get cardDescription value
     * @return string|null
     */
    public function getCardDescription()
    {
        return $this->cardDescription;
    }
    /**
     * Set cardDescription value
     * @param string $cardDescription
     * @return \StructType\AuthDetails
     */
    public function setCardDescription($cardDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cardDescription) && !is_string($cardDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardDescription)), __LINE__);
        }
        $this->cardDescription = $cardDescription;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \StructType\AuthDetails
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get merchantNumber value
     * @return string|null
     */
    public function getMerchantNumber()
    {
        return $this->merchantNumber;
    }
    /**
     * Set merchantNumber value
     * @param string $merchantNumber
     * @return \StructType\AuthDetails
     */
    public function setMerchantNumber($merchantNumber = null)
    {
        // validation for constraint: string
        if (!is_null($merchantNumber) && !is_string($merchantNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantNumber)), __LINE__);
        }
        $this->merchantNumber = $merchantNumber;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param string $expiryDate
     * @return \StructType\AuthDetails
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get uniqueAuthId value
     * @return string|null
     */
    public function getUniqueAuthId()
    {
        return $this->uniqueAuthId;
    }
    /**
     * Set uniqueAuthId value
     * @param string $uniqueAuthId
     * @return \StructType\AuthDetails
     */
    public function setUniqueAuthId($uniqueAuthId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueAuthId) && !is_string($uniqueAuthId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uniqueAuthId)), __LINE__);
        }
        $this->uniqueAuthId = $uniqueAuthId;
        return $this;
    }
    /**
     * Get cssCardType value
     * @return string|null
     */
    public function getCssCardType()
    {
        return $this->cssCardType;
    }
    /**
     * Set cssCardType value
     * @param string $cssCardType
     * @return \StructType\AuthDetails
     */
    public function setCssCardType($cssCardType = null)
    {
        // validation for constraint: string
        if (!is_null($cssCardType) && !is_string($cssCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cssCardType)), __LINE__);
        }
        $this->cssCardType = $cssCardType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
