<?php

namespace EnumType;

/**
 * This class stands for Status EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Status
 * @subpackage Enumerations
 */
class Status
{
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'InvalidRequest'
     * @return string 'InvalidRequest'
     */
    const VALUE_INVALID_REQUEST = 'InvalidRequest';
    /**
     * Constant for value 'InvalidCardDetails'
     * @return string 'InvalidCardDetails'
     */
    const VALUE_INVALID_CARD_DETAILS = 'InvalidCardDetails';
    /**
     * Constant for value 'InvalidLogin'
     * @return string 'InvalidLogin'
     */
    const VALUE_INVALID_LOGIN = 'InvalidLogin';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Constant for value 'LoggedOut'
     * @return string 'LoggedOut'
     */
    const VALUE_LOGGED_OUT = 'LoggedOut';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_INVALID_REQUEST
     * @uses self::VALUE_INVALID_CARD_DETAILS
     * @uses self::VALUE_INVALID_LOGIN
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_LOGGED_OUT
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCESS,
            self::VALUE_INVALID_REQUEST,
            self::VALUE_INVALID_CARD_DETAILS,
            self::VALUE_INVALID_LOGIN,
            self::VALUE_CANCELLED,
            self::VALUE_LOGGED_OUT,
            self::VALUE_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
