<?php

namespace EnumType;

/**
 * This class stands for ProgressState EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProgressState
 * @subpackage Enumerations
 */
class ProgressState
{
    /**
     * Constant for value 'NotStarted'
     * @return string 'NotStarted'
     */
    const VALUE_NOT_STARTED = 'NotStarted';
    /**
     * Constant for value 'InProgress'
     * @return string 'InProgress'
     */
    const VALUE_IN_PROGRESS = 'InProgress';
    /**
     * Constant for value 'Accounts'
     * @return string 'Accounts'
     */
    const VALUE_ACCOUNTS = 'Accounts';
    /**
     * Constant for value 'PayTypeSelection'
     * @return string 'PayTypeSelection'
     */
    const VALUE_PAY_TYPE_SELECTION = 'PayTypeSelection';
    /**
     * Constant for value 'Card'
     * @return string 'Card'
     */
    const VALUE_CARD = 'Card';
    /**
     * Constant for value 'NonCard'
     * @return string 'NonCard'
     */
    const VALUE_NON_CARD = 'NonCard';
    /**
     * Constant for value 'WaitingUpdate'
     * @return string 'WaitingUpdate'
     */
    const VALUE_WAITING_UPDATE = 'WaitingUpdate';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_STARTED
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_ACCOUNTS
     * @uses self::VALUE_PAY_TYPE_SELECTION
     * @uses self::VALUE_CARD
     * @uses self::VALUE_NON_CARD
     * @uses self::VALUE_WAITING_UPDATE
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_STARTED,
            self::VALUE_IN_PROGRESS,
            self::VALUE_ACCOUNTS,
            self::VALUE_PAY_TYPE_SELECTION,
            self::VALUE_CARD,
            self::VALUE_NON_CARD,
            self::VALUE_WAITING_UPDATE,
            self::VALUE_COMPLETED,
            self::VALUE_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
