<?php

namespace EnumType;

/**
 * This class stands for AppConstants.SubjectType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AppConstants.SubjectType
 * @subpackage Enumerations
 */
class AppConstants_SubjectType
{
    /**
     * Constant for value 'CapitaSite'
     * @return string 'CapitaSite'
     */
    const VALUE_CAPITA_SITE = 'CapitaSite';
    /**
     * Constant for value 'Integrator'
     * @return string 'Integrator'
     */
    const VALUE_INTEGRATOR = 'Integrator';
    /**
     * Constant for value 'OtherSecurityEntity'
     * @return string 'OtherSecurityEntity'
     */
    const VALUE_OTHER_SECURITY_ENTITY = 'OtherSecurityEntity';
    /**
     * Constant for value 'SecureBureauServiceSite'
     * @return string 'SecureBureauServiceSite'
     */
    const VALUE_SECURE_BUREAU_SERVICE_SITE = 'SecureBureauServiceSite';
    /**
     * Constant for value 'CapitaPortal'
     * @return string 'CapitaPortal'
     */
    const VALUE_CAPITA_PORTAL = 'CapitaPortal';
    /**
     * Constant for value 'HsmDevice'
     * @return string 'HsmDevice'
     */
    const VALUE_HSM_DEVICE = 'HsmDevice';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CAPITA_SITE
     * @uses self::VALUE_INTEGRATOR
     * @uses self::VALUE_OTHER_SECURITY_ENTITY
     * @uses self::VALUE_SECURE_BUREAU_SERVICE_SITE
     * @uses self::VALUE_CAPITA_PORTAL
     * @uses self::VALUE_HSM_DEVICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CAPITA_SITE,
            self::VALUE_INTEGRATOR,
            self::VALUE_OTHER_SECURITY_ENTITY,
            self::VALUE_SECURE_BUREAU_SERVICE_SITE,
            self::VALUE_CAPITA_PORTAL,
            self::VALUE_HSM_DEVICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
