<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfpaymentSummary ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfpaymentSummary
 * @subpackage Arrays
 */
class ArrayOfpaymentSummary extends AbstractStructArrayBase
{
    /**
     * The paymentSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentSummary[]
     */
    public $paymentSummary;
    /**
     * Constructor method for ArrayOfpaymentSummary
     * @uses ArrayOfpaymentSummary::setPaymentSummary()
     * @param \StructType\PaymentSummary[] $paymentSummary
     */
    public function __construct(array $paymentSummary = array())
    {
        $this
            ->setPaymentSummary($paymentSummary);
    }
    /**
     * Get paymentSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentSummary[]|null
     */
    public function getPaymentSummary()
    {
        return isset($this->paymentSummary) ? $this->paymentSummary : null;
    }
    /**
     * Set paymentSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentSummary[] $paymentSummary
     * @return \ArrayType\ArrayOfpaymentSummary
     */
    public function setPaymentSummary(array $paymentSummary = array())
    {
        foreach ($paymentSummary as $arrayOfpaymentSummaryPaymentSummaryItem) {
            // validation for constraint: itemType
            if (!$arrayOfpaymentSummaryPaymentSummaryItem instanceof \StructType\PaymentSummary) {
                throw new \InvalidArgumentException(sprintf('The paymentSummary property can only contain items of \StructType\PaymentSummary, "%s" given', is_object($arrayOfpaymentSummaryPaymentSummaryItem) ? get_class($arrayOfpaymentSummaryPaymentSummaryItem) : gettype($arrayOfpaymentSummaryPaymentSummaryItem)), __LINE__);
            }
        }
        if (is_null($paymentSummary) || (is_array($paymentSummary) && empty($paymentSummary))) {
            unset($this->paymentSummary);
        } else {
            $this->paymentSummary = $paymentSummary;
        }
        return $this;
    }
    /**
     * Add item to paymentSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentSummary $item
     * @return \ArrayType\ArrayOfpaymentSummary
     */
    public function addToPaymentSummary(\StructType\PaymentSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentSummary) {
            throw new \InvalidArgumentException(sprintf('The paymentSummary property can only contain items of \StructType\PaymentSummary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->paymentSummary[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PaymentSummary|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PaymentSummary|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PaymentSummary|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PaymentSummary|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PaymentSummary|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string paymentSummary
     */
    public function getAttributeName()
    {
        return 'paymentSummary';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfpaymentSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
