<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vat StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:vat
 * @subpackage Structs
 */
class Vat extends AbstractStructBase
{
    /**
     * The vatCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $vatCode;
    /**
     * The vatRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vatRate;
    /**
     * The vatAmountInMinorUnits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $vatAmountInMinorUnits;
    /**
     * Constructor method for vat
     * @uses Vat::setVatCode()
     * @uses Vat::setVatRate()
     * @uses Vat::setVatAmountInMinorUnits()
     * @param string $vatCode
     * @param float $vatRate
     * @param int $vatAmountInMinorUnits
     */
    public function __construct($vatCode = null, $vatRate = null, $vatAmountInMinorUnits = null)
    {
        $this
            ->setVatCode($vatCode)
            ->setVatRate($vatRate)
            ->setVatAmountInMinorUnits($vatAmountInMinorUnits);
    }
    /**
     * Get vatCode value
     * @return string|null
     */
    public function getVatCode()
    {
        return $this->vatCode;
    }
    /**
     * Set vatCode value
     * @param string $vatCode
     * @return \StructType\Vat
     */
    public function setVatCode($vatCode = null)
    {
        // validation for constraint: string
        if (!is_null($vatCode) && !is_string($vatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vatCode)), __LINE__);
        }
        $this->vatCode = $vatCode;
        return $this;
    }
    /**
     * Get vatRate value
     * @return float|null
     */
    public function getVatRate()
    {
        return $this->vatRate;
    }
    /**
     * Set vatRate value
     * @param float $vatRate
     * @return \StructType\Vat
     */
    public function setVatRate($vatRate = null)
    {
        $this->vatRate = $vatRate;
        return $this;
    }
    /**
     * Get vatAmountInMinorUnits value
     * @return int|null
     */
    public function getVatAmountInMinorUnits()
    {
        return $this->vatAmountInMinorUnits;
    }
    /**
     * Set vatAmountInMinorUnits value
     * @param int $vatAmountInMinorUnits
     * @return \StructType\Vat
     */
    public function setVatAmountInMinorUnits($vatAmountInMinorUnits = null)
    {
        // validation for constraint: int
        if (!is_null($vatAmountInMinorUnits) && !is_numeric($vatAmountInMinorUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vatAmountInMinorUnits)), __LINE__);
        }
        $this->vatAmountInMinorUnits = $vatAmountInMinorUnits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
