<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateItem StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:updateItem
 * @subpackage Structs
 */
class UpdateItem extends AbstractStructBase
{
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $reference;
    /**
     * The lineId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lineId;
    /**
     * The additionalInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdditionalInfo
     */
    public $additionalInfo;
    /**
     * Constructor method for updateItem
     * @uses UpdateItem::setReference()
     * @uses UpdateItem::setLineId()
     * @uses UpdateItem::setAdditionalInfo()
     * @param string $reference
     * @param string $lineId
     * @param \StructType\AdditionalInfo $additionalInfo
     */
    public function __construct($reference = null, $lineId = null, \StructType\AdditionalInfo $additionalInfo = null)
    {
        $this
            ->setReference($reference)
            ->setLineId($lineId)
            ->setAdditionalInfo($additionalInfo);
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\UpdateItem
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get lineId value
     * @return string|null
     */
    public function getLineId()
    {
        return $this->lineId;
    }
    /**
     * Set lineId value
     * @param string $lineId
     * @return \StructType\UpdateItem
     */
    public function setLineId($lineId = null)
    {
        // validation for constraint: string
        if (!is_null($lineId) && !is_string($lineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineId)), __LINE__);
        }
        $this->lineId = $lineId;
        return $this;
    }
    /**
     * Get additionalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdditionalInfo|null
     */
    public function getAdditionalInfo()
    {
        return isset($this->additionalInfo) ? $this->additionalInfo : null;
    }
    /**
     * Set additionalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdditionalInfo $additionalInfo
     * @return \StructType\UpdateItem
     */
    public function setAdditionalInfo(\StructType\AdditionalInfo $additionalInfo = null)
    {
        if (is_null($additionalInfo) || (is_array($additionalInfo) && empty($additionalInfo))) {
            unset($this->additionalInfo);
        } else {
            $this->additionalInfo = $additionalInfo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
