<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for surchargeDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:surchargeDetails
 * @subpackage Structs
 */
class SurchargeDetails extends AbstractStructBase
{
    /**
     * The fundCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $fundCode;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $reference;
    /**
     * The amountInMinorUnits
     * @var int
     */
    public $amountInMinorUnits;
    /**
     * The surchargeBasis
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\SurchargeBasis
     */
    public $surchargeBasis;
    /**
     * The vatAmountInMinorUnits
     * @var int
     */
    public $vatAmountInMinorUnits;
    /**
     * Constructor method for surchargeDetails
     * @uses SurchargeDetails::setFundCode()
     * @uses SurchargeDetails::setReference()
     * @uses SurchargeDetails::setAmountInMinorUnits()
     * @uses SurchargeDetails::setSurchargeBasis()
     * @uses SurchargeDetails::setVatAmountInMinorUnits()
     * @param string $fundCode
     * @param string $reference
     * @param int $amountInMinorUnits
     * @param \StructType\SurchargeBasis $surchargeBasis
     * @param int $vatAmountInMinorUnits
     */
    public function __construct($fundCode = null, $reference = null, $amountInMinorUnits = null, \StructType\SurchargeBasis $surchargeBasis = null, $vatAmountInMinorUnits = null)
    {
        $this
            ->setFundCode($fundCode)
            ->setReference($reference)
            ->setAmountInMinorUnits($amountInMinorUnits)
            ->setSurchargeBasis($surchargeBasis)
            ->setVatAmountInMinorUnits($vatAmountInMinorUnits);
    }
    /**
     * Get fundCode value
     * @return string|null
     */
    public function getFundCode()
    {
        return $this->fundCode;
    }
    /**
     * Set fundCode value
     * @param string $fundCode
     * @return \StructType\SurchargeDetails
     */
    public function setFundCode($fundCode = null)
    {
        // validation for constraint: string
        if (!is_null($fundCode) && !is_string($fundCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fundCode)), __LINE__);
        }
        $this->fundCode = $fundCode;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\SurchargeDetails
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get amountInMinorUnits value
     * @return int|null
     */
    public function getAmountInMinorUnits()
    {
        return $this->amountInMinorUnits;
    }
    /**
     * Set amountInMinorUnits value
     * @param int $amountInMinorUnits
     * @return \StructType\SurchargeDetails
     */
    public function setAmountInMinorUnits($amountInMinorUnits = null)
    {
        // validation for constraint: int
        if (!is_null($amountInMinorUnits) && !is_numeric($amountInMinorUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amountInMinorUnits)), __LINE__);
        }
        $this->amountInMinorUnits = $amountInMinorUnits;
        return $this;
    }
    /**
     * Get surchargeBasis value
     * @return \StructType\SurchargeBasis|null
     */
    public function getSurchargeBasis()
    {
        return $this->surchargeBasis;
    }
    /**
     * Set surchargeBasis value
     * @param \StructType\SurchargeBasis $surchargeBasis
     * @return \StructType\SurchargeDetails
     */
    public function setSurchargeBasis(\StructType\SurchargeBasis $surchargeBasis = null)
    {
        $this->surchargeBasis = $surchargeBasis;
        return $this;
    }
    /**
     * Get vatAmountInMinorUnits value
     * @return int|null
     */
    public function getVatAmountInMinorUnits()
    {
        return $this->vatAmountInMinorUnits;
    }
    /**
     * Set vatAmountInMinorUnits value
     * @param int $vatAmountInMinorUnits
     * @return \StructType\SurchargeDetails
     */
    public function setVatAmountInMinorUnits($vatAmountInMinorUnits = null)
    {
        // validation for constraint: int
        if (!is_null($vatAmountInMinorUnits) && !is_numeric($vatAmountInMinorUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vatAmountInMinorUnits)), __LINE__);
        }
        $this->vatAmountInMinorUnits = $vatAmountInMinorUnits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SurchargeDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
