<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subject StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:subject
 * @subpackage Structs
 */
class Subject extends AbstractStructBase
{
    /**
     * The subjectType
     * @var string
     */
    public $subjectType;
    /**
     * The identifier
     * @var int
     */
    public $identifier;
    /**
     * The systemCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $systemCode;
    /**
     * Constructor method for subject
     * @uses Subject::setSubjectType()
     * @uses Subject::setIdentifier()
     * @uses Subject::setSystemCode()
     * @param string $subjectType
     * @param int $identifier
     * @param string $systemCode
     */
    public function __construct($subjectType = null, $identifier = null, $systemCode = null)
    {
        $this
            ->setSubjectType($subjectType)
            ->setIdentifier($identifier)
            ->setSystemCode($systemCode);
    }
    /**
     * Get subjectType value
     * @return string|null
     */
    public function getSubjectType()
    {
        return $this->subjectType;
    }
    /**
     * Set subjectType value
     * @uses \EnumType\AppConstants_SubjectType::valueIsValid()
     * @uses \EnumType\AppConstants_SubjectType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subjectType
     * @return \StructType\Subject
     */
    public function setSubjectType($subjectType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AppConstants_SubjectType::valueIsValid($subjectType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subjectType, implode(', ', \EnumType\AppConstants_SubjectType::getValidValues())), __LINE__);
        }
        $this->subjectType = $subjectType;
        return $this;
    }
    /**
     * Get identifier value
     * @return int|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param int $identifier
     * @return \StructType\Subject
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: int
        if (!is_null($identifier) && !is_numeric($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($identifier)), __LINE__);
        }
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get systemCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemCode()
    {
        return isset($this->systemCode) ? $this->systemCode : null;
    }
    /**
     * Set systemCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemCode
     * @return \StructType\Subject
     */
    public function setSystemCode($systemCode = null)
    {
        // validation for constraint: string
        if (!is_null($systemCode) && !is_string($systemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemCode)), __LINE__);
        }
        if (is_null($systemCode) || (is_array($systemCode) && empty($systemCode))) {
            unset($this->systemCode);
        } else {
            $this->systemCode = $systemCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Subject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
