<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storedCardKey StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:storedCardKey
 * @subpackage Structs
 */
class StoredCardKey extends AbstractStructBase
{
    /**
     * The token
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $token;
    /**
     * The lastFourDigits
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lastFourDigits;
    /**
     * The mnemonic
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $mnemonic;
    /**
     * The cardholderId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cardholderId;
    /**
     * The cssCardType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cssCardType;
    /**
     * Constructor method for storedCardKey
     * @uses StoredCardKey::setToken()
     * @uses StoredCardKey::setLastFourDigits()
     * @uses StoredCardKey::setMnemonic()
     * @uses StoredCardKey::setCardholderId()
     * @uses StoredCardKey::setCssCardType()
     * @param string $token
     * @param string $lastFourDigits
     * @param string $mnemonic
     * @param string $cardholderId
     * @param string $cssCardType
     */
    public function __construct($token = null, $lastFourDigits = null, $mnemonic = null, $cardholderId = null, $cssCardType = null)
    {
        $this
            ->setToken($token)
            ->setLastFourDigits($lastFourDigits)
            ->setMnemonic($mnemonic)
            ->setCardholderId($cardholderId)
            ->setCssCardType($cssCardType);
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\StoredCardKey
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Get lastFourDigits value
     * @return string|null
     */
    public function getLastFourDigits()
    {
        return $this->lastFourDigits;
    }
    /**
     * Set lastFourDigits value
     * @param string $lastFourDigits
     * @return \StructType\StoredCardKey
     */
    public function setLastFourDigits($lastFourDigits = null)
    {
        // validation for constraint: string
        if (!is_null($lastFourDigits) && !is_string($lastFourDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastFourDigits)), __LINE__);
        }
        $this->lastFourDigits = $lastFourDigits;
        return $this;
    }
    /**
     * Get mnemonic value
     * @return string|null
     */
    public function getMnemonic()
    {
        return $this->mnemonic;
    }
    /**
     * Set mnemonic value
     * @param string $mnemonic
     * @return \StructType\StoredCardKey
     */
    public function setMnemonic($mnemonic = null)
    {
        // validation for constraint: string
        if (!is_null($mnemonic) && !is_string($mnemonic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mnemonic)), __LINE__);
        }
        $this->mnemonic = $mnemonic;
        return $this;
    }
    /**
     * Get cardholderId value
     * @return string|null
     */
    public function getCardholderId()
    {
        return $this->cardholderId;
    }
    /**
     * Set cardholderId value
     * @param string $cardholderId
     * @return \StructType\StoredCardKey
     */
    public function setCardholderId($cardholderId = null)
    {
        // validation for constraint: string
        if (!is_null($cardholderId) && !is_string($cardholderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardholderId)), __LINE__);
        }
        $this->cardholderId = $cardholderId;
        return $this;
    }
    /**
     * Get cssCardType value
     * @return string|null
     */
    public function getCssCardType()
    {
        return $this->cssCardType;
    }
    /**
     * Set cssCardType value
     * @param string $cssCardType
     * @return \StructType\StoredCardKey
     */
    public function setCssCardType($cssCardType = null)
    {
        // validation for constraint: string
        if (!is_null($cssCardType) && !is_string($cssCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cssCardType)), __LINE__);
        }
        $this->cssCardType = $cssCardType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoredCardKey
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
