<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for signature StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:signature
 * @subpackage Structs
 */
class Signature extends AbstractStructBase
{
    /**
     * The algorithm
     * @var string
     */
    public $algorithm;
    /**
     * The hmacKeyID
     * @var int
     */
    public $hmacKeyID;
    /**
     * The digest
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $digest;
    /**
     * Constructor method for signature
     * @uses Signature::setAlgorithm()
     * @uses Signature::setHmacKeyID()
     * @uses Signature::setDigest()
     * @param string $algorithm
     * @param int $hmacKeyID
     * @param string $digest
     */
    public function __construct($algorithm = null, $hmacKeyID = null, $digest = null)
    {
        $this
            ->setAlgorithm($algorithm)
            ->setHmacKeyID($hmacKeyID)
            ->setDigest($digest);
    }
    /**
     * Get algorithm value
     * @return string|null
     */
    public function getAlgorithm()
    {
        return $this->algorithm;
    }
    /**
     * Set algorithm value
     * @uses \EnumType\AppConstants_Algorithm::valueIsValid()
     * @uses \EnumType\AppConstants_Algorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $algorithm
     * @return \StructType\Signature
     */
    public function setAlgorithm($algorithm = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AppConstants_Algorithm::valueIsValid($algorithm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $algorithm, implode(', ', \EnumType\AppConstants_Algorithm::getValidValues())), __LINE__);
        }
        $this->algorithm = $algorithm;
        return $this;
    }
    /**
     * Get hmacKeyID value
     * @return int|null
     */
    public function getHmacKeyID()
    {
        return $this->hmacKeyID;
    }
    /**
     * Set hmacKeyID value
     * @param int $hmacKeyID
     * @return \StructType\Signature
     */
    public function setHmacKeyID($hmacKeyID = null)
    {
        // validation for constraint: int
        if (!is_null($hmacKeyID) && !is_numeric($hmacKeyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hmacKeyID)), __LINE__);
        }
        $this->hmacKeyID = $hmacKeyID;
        return $this;
    }
    /**
     * Get digest value
     * @return string|null
     */
    public function getDigest()
    {
        return $this->digest;
    }
    /**
     * Set digest value
     * @param string $digest
     * @return \StructType\Signature
     */
    public function setDigest($digest = null)
    {
        // validation for constraint: string
        if (!is_null($digest) && !is_string($digest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digest)), __LINE__);
        }
        $this->digest = $digest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Signature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
