<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saleSummary StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:saleSummary
 * @subpackage Structs
 */
class SaleSummary extends AbstractStructBase
{
    /**
     * The lineId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lineId;
    /**
     * The continuousAuditNumber
     * @var int
     */
    public $continuousAuditNumber;
    /**
     * Constructor method for saleSummary
     * @uses SaleSummary::setLineId()
     * @uses SaleSummary::setContinuousAuditNumber()
     * @param string $lineId
     * @param int $continuousAuditNumber
     */
    public function __construct($lineId = null, $continuousAuditNumber = null)
    {
        $this
            ->setLineId($lineId)
            ->setContinuousAuditNumber($continuousAuditNumber);
    }
    /**
     * Get lineId value
     * @return string|null
     */
    public function getLineId()
    {
        return $this->lineId;
    }
    /**
     * Set lineId value
     * @param string $lineId
     * @return \StructType\SaleSummary
     */
    public function setLineId($lineId = null)
    {
        // validation for constraint: string
        if (!is_null($lineId) && !is_string($lineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineId)), __LINE__);
        }
        $this->lineId = $lineId;
        return $this;
    }
    /**
     * Get continuousAuditNumber value
     * @return int|null
     */
    public function getContinuousAuditNumber()
    {
        return $this->continuousAuditNumber;
    }
    /**
     * Set continuousAuditNumber value
     * @param int $continuousAuditNumber
     * @return \StructType\SaleSummary
     */
    public function setContinuousAuditNumber($continuousAuditNumber = null)
    {
        // validation for constraint: int
        if (!is_null($continuousAuditNumber) && !is_numeric($continuousAuditNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($continuousAuditNumber)), __LINE__);
        }
        $this->continuousAuditNumber = $continuousAuditNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
