<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for routing StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:routing
 * @subpackage Structs
 */
class Routing extends AbstractStructBase
{
    /**
     * The returnUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $returnUrl;
    /**
     * The assistanceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $assistanceNumber;
    /**
     * The returnNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $returnNumber;
    /**
     * Constructor method for routing
     * @uses Routing::setReturnUrl()
     * @uses Routing::setAssistanceNumber()
     * @uses Routing::setReturnNumber()
     * @param string $returnUrl
     * @param string $assistanceNumber
     * @param string $returnNumber
     */
    public function __construct($returnUrl = null, $assistanceNumber = null, $returnNumber = null)
    {
        $this
            ->setReturnUrl($returnUrl)
            ->setAssistanceNumber($assistanceNumber)
            ->setReturnNumber($returnNumber);
    }
    /**
     * Get returnUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnUrl()
    {
        return isset($this->returnUrl) ? $this->returnUrl : null;
    }
    /**
     * Set returnUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnUrl
     * @return \StructType\Routing
     */
    public function setReturnUrl($returnUrl = null)
    {
        // validation for constraint: string
        if (!is_null($returnUrl) && !is_string($returnUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnUrl)), __LINE__);
        }
        if (is_null($returnUrl) || (is_array($returnUrl) && empty($returnUrl))) {
            unset($this->returnUrl);
        } else {
            $this->returnUrl = $returnUrl;
        }
        return $this;
    }
    /**
     * Get assistanceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssistanceNumber()
    {
        return isset($this->assistanceNumber) ? $this->assistanceNumber : null;
    }
    /**
     * Set assistanceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assistanceNumber
     * @return \StructType\Routing
     */
    public function setAssistanceNumber($assistanceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($assistanceNumber) && !is_string($assistanceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assistanceNumber)), __LINE__);
        }
        if (is_null($assistanceNumber) || (is_array($assistanceNumber) && empty($assistanceNumber))) {
            unset($this->assistanceNumber);
        } else {
            $this->assistanceNumber = $assistanceNumber;
        }
        return $this;
    }
    /**
     * Get returnNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnNumber()
    {
        return isset($this->returnNumber) ? $this->returnNumber : null;
    }
    /**
     * Set returnNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnNumber
     * @return \StructType\Routing
     */
    public function setReturnNumber($returnNumber = null)
    {
        // validation for constraint: string
        if (!is_null($returnNumber) && !is_string($returnNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnNumber)), __LINE__);
        }
        if (is_null($returnNumber) || (is_array($returnNumber) && empty($returnNumber))) {
            unset($this->returnNumber);
        } else {
            $this->returnNumber = $returnNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Routing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
