<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for queryResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:queryResponse
 * @subpackage Structs
 */
class QueryResponse_1 extends BaseResponse
{
    /**
     * The storeCardResult
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\StoreCardResult
     */
    public $storeCardResult;
    /**
     * The paymentResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentResult
     */
    public $paymentResult;
    /**
     * Constructor method for queryResponse
     * @uses QueryResponse_1::setStoreCardResult()
     * @uses QueryResponse_1::setPaymentResult()
     * @param \StructType\StoreCardResult $storeCardResult
     * @param \StructType\PaymentResult $paymentResult
     */
    public function __construct(\StructType\StoreCardResult $storeCardResult = null, \StructType\PaymentResult $paymentResult = null)
    {
        $this
            ->setStoreCardResult($storeCardResult)
            ->setPaymentResult($paymentResult);
    }
    /**
     * Get storeCardResult value
     * @return \StructType\StoreCardResult|null
     */
    public function getStoreCardResult()
    {
        return $this->storeCardResult;
    }
    /**
     * Set storeCardResult value
     * @param \StructType\StoreCardResult $storeCardResult
     * @return \StructType\QueryResponse_1
     */
    public function setStoreCardResult(\StructType\StoreCardResult $storeCardResult = null)
    {
        $this->storeCardResult = $storeCardResult;
        return $this;
    }
    /**
     * Get paymentResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentResult|null
     */
    public function getPaymentResult()
    {
        return isset($this->paymentResult) ? $this->paymentResult : null;
    }
    /**
     * Set paymentResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PaymentResult $paymentResult
     * @return \StructType\QueryResponse_1
     */
    public function setPaymentResult(\StructType\PaymentResult $paymentResult = null)
    {
        if (is_null($paymentResult) || (is_array($paymentResult) && empty($paymentResult))) {
            unset($this->paymentResult);
        } else {
            $this->paymentResult = $paymentResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QueryResponse_1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
