<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentHeader StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:paymentHeader
 * @subpackage Structs
 */
class PaymentHeader extends AbstractStructBase
{
    /**
     * The transactionDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $transactionDate;
    /**
     * The machineCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $machineCode;
    /**
     * Constructor method for paymentHeader
     * @uses PaymentHeader::setTransactionDate()
     * @uses PaymentHeader::setMachineCode()
     * @param string $transactionDate
     * @param string $machineCode
     */
    public function __construct($transactionDate = null, $machineCode = null)
    {
        $this
            ->setTransactionDate($transactionDate)
            ->setMachineCode($machineCode);
    }
    /**
     * Get transactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->transactionDate;
    }
    /**
     * Set transactionDate value
     * @param string $transactionDate
     * @return \StructType\PaymentHeader
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDate)), __LINE__);
        }
        $this->transactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get machineCode value
     * @return string|null
     */
    public function getMachineCode()
    {
        return $this->machineCode;
    }
    /**
     * Set machineCode value
     * @param string $machineCode
     * @return \StructType\PaymentHeader
     */
    public function setMachineCode($machineCode = null)
    {
        // validation for constraint: string
        if (!is_null($machineCode) && !is_string($machineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($machineCode)), __LINE__);
        }
        $this->machineCode = $machineCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
