<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:paymentDetails
 * @subpackage Structs
 */
class PaymentDetails extends AbstractStructBase
{
    /**
     * The paymentHeader
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\PaymentHeader
     */
    public $paymentHeader;
    /**
     * The authDetails
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\AuthDetails
     */
    public $authDetails;
    /**
     * The surchargeDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SurchargeDetails
     */
    public $surchargeDetails;
    /**
     * The sales
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfsaleSummary
     */
    public $sales;
    /**
     * The payments
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfpaymentSummary
     */
    public $payments;
    /**
     * Constructor method for paymentDetails
     * @uses PaymentDetails::setPaymentHeader()
     * @uses PaymentDetails::setAuthDetails()
     * @uses PaymentDetails::setSurchargeDetails()
     * @uses PaymentDetails::setSales()
     * @uses PaymentDetails::setPayments()
     * @param \StructType\PaymentHeader $paymentHeader
     * @param \StructType\AuthDetails $authDetails
     * @param \StructType\SurchargeDetails $surchargeDetails
     * @param \ArrayType\ArrayOfsaleSummary $sales
     * @param \ArrayType\ArrayOfpaymentSummary $payments
     */
    public function __construct(\StructType\PaymentHeader $paymentHeader = null, \StructType\AuthDetails $authDetails = null, \StructType\SurchargeDetails $surchargeDetails = null, \ArrayType\ArrayOfsaleSummary $sales = null, \ArrayType\ArrayOfpaymentSummary $payments = null)
    {
        $this
            ->setPaymentHeader($paymentHeader)
            ->setAuthDetails($authDetails)
            ->setSurchargeDetails($surchargeDetails)
            ->setSales($sales)
            ->setPayments($payments);
    }
    /**
     * Get paymentHeader value
     * @return \StructType\PaymentHeader|null
     */
    public function getPaymentHeader()
    {
        return $this->paymentHeader;
    }
    /**
     * Set paymentHeader value
     * @param \StructType\PaymentHeader $paymentHeader
     * @return \StructType\PaymentDetails
     */
    public function setPaymentHeader(\StructType\PaymentHeader $paymentHeader = null)
    {
        $this->paymentHeader = $paymentHeader;
        return $this;
    }
    /**
     * Get authDetails value
     * @return \StructType\AuthDetails|null
     */
    public function getAuthDetails()
    {
        return $this->authDetails;
    }
    /**
     * Set authDetails value
     * @param \StructType\AuthDetails $authDetails
     * @return \StructType\PaymentDetails
     */
    public function setAuthDetails(\StructType\AuthDetails $authDetails = null)
    {
        $this->authDetails = $authDetails;
        return $this;
    }
    /**
     * Get surchargeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SurchargeDetails|null
     */
    public function getSurchargeDetails()
    {
        return isset($this->surchargeDetails) ? $this->surchargeDetails : null;
    }
    /**
     * Set surchargeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SurchargeDetails $surchargeDetails
     * @return \StructType\PaymentDetails
     */
    public function setSurchargeDetails(\StructType\SurchargeDetails $surchargeDetails = null)
    {
        if (is_null($surchargeDetails) || (is_array($surchargeDetails) && empty($surchargeDetails))) {
            unset($this->surchargeDetails);
        } else {
            $this->surchargeDetails = $surchargeDetails;
        }
        return $this;
    }
    /**
     * Get sales value
     * @return \ArrayType\ArrayOfsaleSummary|null
     */
    public function getSales()
    {
        return $this->sales;
    }
    /**
     * Set sales value
     * @param \ArrayType\ArrayOfsaleSummary $sales
     * @return \StructType\PaymentDetails
     */
    public function setSales(\ArrayType\ArrayOfsaleSummary $sales = null)
    {
        $this->sales = $sales;
        return $this;
    }
    /**
     * Get payments value
     * @return \ArrayType\ArrayOfpaymentSummary|null
     */
    public function getPayments()
    {
        return $this->payments;
    }
    /**
     * Set payments value
     * @param \ArrayType\ArrayOfpaymentSummary $payments
     * @return \StructType\PaymentDetails
     */
    public function setPayments(\ArrayType\ArrayOfpaymentSummary $payments = null)
    {
        $this->payments = $payments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
