<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for item StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:item
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The itemDetails
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\ItemDetails
     */
    public $itemDetails;
    /**
     * The vat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Vat
     */
    public $vat;
    /**
     * The customerInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerInfo
     */
    public $customerInfo;
    /**
     * The lineId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lineId;
    /**
     * Constructor method for item
     * @uses Item::setItemDetails()
     * @uses Item::setVat()
     * @uses Item::setCustomerInfo()
     * @uses Item::setLineId()
     * @param \StructType\ItemDetails $itemDetails
     * @param \StructType\Vat $vat
     * @param \StructType\CustomerInfo $customerInfo
     * @param string $lineId
     */
    public function __construct(\StructType\ItemDetails $itemDetails = null, \StructType\Vat $vat = null, \StructType\CustomerInfo $customerInfo = null, $lineId = null)
    {
        $this
            ->setItemDetails($itemDetails)
            ->setVat($vat)
            ->setCustomerInfo($customerInfo)
            ->setLineId($lineId);
    }
    /**
     * Get itemDetails value
     * @return \StructType\ItemDetails|null
     */
    public function getItemDetails()
    {
        return $this->itemDetails;
    }
    /**
     * Set itemDetails value
     * @param \StructType\ItemDetails $itemDetails
     * @return \StructType\Item
     */
    public function setItemDetails(\StructType\ItemDetails $itemDetails = null)
    {
        $this->itemDetails = $itemDetails;
        return $this;
    }
    /**
     * Get vat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Vat|null
     */
    public function getVat()
    {
        return isset($this->vat) ? $this->vat : null;
    }
    /**
     * Set vat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Vat $vat
     * @return \StructType\Item
     */
    public function setVat(\StructType\Vat $vat = null)
    {
        if (is_null($vat) || (is_array($vat) && empty($vat))) {
            unset($this->vat);
        } else {
            $this->vat = $vat;
        }
        return $this;
    }
    /**
     * Get customerInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerInfo|null
     */
    public function getCustomerInfo()
    {
        return isset($this->customerInfo) ? $this->customerInfo : null;
    }
    /**
     * Set customerInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerInfo $customerInfo
     * @return \StructType\Item
     */
    public function setCustomerInfo(\StructType\CustomerInfo $customerInfo = null)
    {
        if (is_null($customerInfo) || (is_array($customerInfo) && empty($customerInfo))) {
            unset($this->customerInfo);
        } else {
            $this->customerInfo = $customerInfo;
        }
        return $this;
    }
    /**
     * Get lineId value
     * @return string|null
     */
    public function getLineId()
    {
        return $this->lineId;
    }
    /**
     * Set lineId value
     * @param string $lineId
     * @return \StructType\Item
     */
    public function setLineId($lineId = null)
    {
        // validation for constraint: string
        if (!is_null($lineId) && !is_string($lineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineId)), __LINE__);
        }
        $this->lineId = $lineId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
