<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for invokeRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:invokeRequest
 * @subpackage Structs
 */
class InvokeRequest extends AbstractStructBase
{
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $credentials;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\LoginDetails
     */
    public $login;
    /**
     * The requestType
     * @var string
     */
    public $requestType;
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $requestId;
    /**
     * The routing
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Routing
     */
    public $routing;
    /**
     * The billing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BillingDetails
     */
    public $billing;
    /**
     * The sale
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Sale
     */
    public $sale;
    /**
     * Constructor method for invokeRequest
     * @uses InvokeRequest::setCredentials()
     * @uses InvokeRequest::setLogin()
     * @uses InvokeRequest::setRequestType()
     * @uses InvokeRequest::setRequestId()
     * @uses InvokeRequest::setRouting()
     * @uses InvokeRequest::setBilling()
     * @uses InvokeRequest::setSale()
     * @param \StructType\Credentials $credentials
     * @param \StructType\LoginDetails $login
     * @param string $requestType
     * @param string $requestId
     * @param \StructType\Routing $routing
     * @param \StructType\BillingDetails $billing
     * @param \StructType\Sale $sale
     */
    public function __construct(\StructType\Credentials $credentials = null, \StructType\LoginDetails $login = null, $requestType = null, $requestId = null, \StructType\Routing $routing = null, \StructType\BillingDetails $billing = null, \StructType\Sale $sale = null)
    {
        $this
            ->setCredentials($credentials)
            ->setLogin($login)
            ->setRequestType($requestType)
            ->setRequestId($requestId)
            ->setRouting($routing)
            ->setBilling($billing)
            ->setSale($sale);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $credentials
     * @return \StructType\InvokeRequest
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get login value
     * @return \StructType\LoginDetails|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\LoginDetails $login
     * @return \StructType\InvokeRequest
     */
    public function setLogin(\StructType\LoginDetails $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get requestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->requestType;
    }
    /**
     * Set requestType value
     * @uses \EnumType\RequestType::valueIsValid()
     * @uses \EnumType\RequestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestType
     * @return \StructType\InvokeRequest
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RequestType::valueIsValid($requestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestType, implode(', ', \EnumType\RequestType::getValidValues())), __LINE__);
        }
        $this->requestType = $requestType;
        return $this;
    }
    /**
     * Get requestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param string $requestId
     * @return \StructType\InvokeRequest
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get routing value
     * @return \StructType\Routing|null
     */
    public function getRouting()
    {
        return $this->routing;
    }
    /**
     * Set routing value
     * @param \StructType\Routing $routing
     * @return \StructType\InvokeRequest
     */
    public function setRouting(\StructType\Routing $routing = null)
    {
        $this->routing = $routing;
        return $this;
    }
    /**
     * Get billing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BillingDetails|null
     */
    public function getBilling()
    {
        return isset($this->billing) ? $this->billing : null;
    }
    /**
     * Set billing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BillingDetails $billing
     * @return \StructType\InvokeRequest
     */
    public function setBilling(\StructType\BillingDetails $billing = null)
    {
        if (is_null($billing) || (is_array($billing) && empty($billing))) {
            unset($this->billing);
        } else {
            $this->billing = $billing;
        }
        return $this;
    }
    /**
     * Get sale value
     * @return \StructType\Sale|null
     */
    public function getSale()
    {
        return $this->sale;
    }
    /**
     * Set sale value
     * @param \StructType\Sale $sale
     * @return \StructType\InvokeRequest
     */
    public function setSale(\StructType\Sale $sale = null)
    {
        $this->sale = $sale;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvokeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
