<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BaseRequest
 * @subpackage Structs
 */
class BaseRequest extends AbstractStructBase
{
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $credentials;
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $requestId;
    /**
     * The apnReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $apnReference;
    /**
     * Constructor method for BaseRequest
     * @uses BaseRequest::setCredentials()
     * @uses BaseRequest::setRequestId()
     * @uses BaseRequest::setApnReference()
     * @param \StructType\Credentials $credentials
     * @param string $requestId
     * @param string $apnReference
     */
    public function __construct(\StructType\Credentials $credentials = null, $requestId = null, $apnReference = null)
    {
        $this
            ->setCredentials($credentials)
            ->setRequestId($requestId)
            ->setApnReference($apnReference);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $credentials
     * @return \StructType\BaseRequest
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get requestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param string $requestId
     * @return \StructType\BaseRequest
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get apnReference value
     * @return string|null
     */
    public function getApnReference()
    {
        return $this->apnReference;
    }
    /**
     * Set apnReference value
     * @param string $apnReference
     * @return \StructType\BaseRequest
     */
    public function setApnReference($apnReference = null)
    {
        // validation for constraint: string
        if (!is_null($apnReference) && !is_string($apnReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apnReference)), __LINE__);
        }
        $this->apnReference = $apnReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
