<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for additionalInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:additionalInfo
 * @subpackage Structs
 */
class AdditionalInfo extends AbstractStructBase
{
    /**
     * The narrative
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $narrative;
    /**
     * The additionalReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $additionalReference;
    /**
     * The subReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subReference;
    /**
     * Constructor method for additionalInfo
     * @uses AdditionalInfo::setNarrative()
     * @uses AdditionalInfo::setAdditionalReference()
     * @uses AdditionalInfo::setSubReference()
     * @param string $narrative
     * @param string $additionalReference
     * @param string $subReference
     */
    public function __construct($narrative = null, $additionalReference = null, $subReference = null)
    {
        $this
            ->setNarrative($narrative)
            ->setAdditionalReference($additionalReference)
            ->setSubReference($subReference);
    }
    /**
     * Get narrative value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNarrative()
    {
        return isset($this->narrative) ? $this->narrative : null;
    }
    /**
     * Set narrative value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $narrative
     * @return \StructType\AdditionalInfo
     */
    public function setNarrative($narrative = null)
    {
        // validation for constraint: string
        if (!is_null($narrative) && !is_string($narrative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($narrative)), __LINE__);
        }
        if (is_null($narrative) || (is_array($narrative) && empty($narrative))) {
            unset($this->narrative);
        } else {
            $this->narrative = $narrative;
        }
        return $this;
    }
    /**
     * Get additionalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdditionalReference()
    {
        return isset($this->additionalReference) ? $this->additionalReference : null;
    }
    /**
     * Set additionalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $additionalReference
     * @return \StructType\AdditionalInfo
     */
    public function setAdditionalReference($additionalReference = null)
    {
        // validation for constraint: string
        if (!is_null($additionalReference) && !is_string($additionalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additionalReference)), __LINE__);
        }
        if (is_null($additionalReference) || (is_array($additionalReference) && empty($additionalReference))) {
            unset($this->additionalReference);
        } else {
            $this->additionalReference = $additionalReference;
        }
        return $this;
    }
    /**
     * Get subReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubReference()
    {
        return isset($this->subReference) ? $this->subReference : null;
    }
    /**
     * Set subReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subReference
     * @return \StructType\AdditionalInfo
     */
    public function setSubReference($subReference = null)
    {
        // validation for constraint: string
        if (!is_null($subReference) && !is_string($subReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subReference)), __LINE__);
        }
        if (is_null($subReference) || (is_array($subReference) && empty($subReference))) {
            unset($this->subReference);
        } else {
            $this->subReference = $subReference;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
