<?php

namespace EnumType;

/**
 * This class stands for RequestType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RequestType
 * @subpackage Enumerations
 */
class RequestType
{
    /**
     * Constant for value 'PayOnly'
     * @return string 'PayOnly'
     */
    const VALUE_PAY_ONLY = 'PayOnly';
    /**
     * Constant for value 'AuthoriseOnly'
     * @return string 'AuthoriseOnly'
     */
    const VALUE_AUTHORISE_ONLY = 'AuthoriseOnly';
    /**
     * Constant for value 'PayAndStore'
     * @return string 'PayAndStore'
     */
    const VALUE_PAY_AND_STORE = 'PayAndStore';
    /**
     * Constant for value 'AuthoriseAndStore'
     * @return string 'AuthoriseAndStore'
     */
    const VALUE_AUTHORISE_AND_STORE = 'AuthoriseAndStore';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PAY_ONLY
     * @uses self::VALUE_AUTHORISE_ONLY
     * @uses self::VALUE_PAY_AND_STORE
     * @uses self::VALUE_AUTHORISE_AND_STORE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PAY_ONLY,
            self::VALUE_AUTHORISE_ONLY,
            self::VALUE_PAY_AND_STORE,
            self::VALUE_AUTHORISE_AND_STORE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
