<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Write ServiceType
 * @subpackage Services
 */
class Write extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named WriteLines
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WriteLines $parameters
     * @return \StructType\WriteLinesResponse|bool
     */
    public function WriteLines(\StructType\WriteLines $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WriteLines($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WriteLinesInsertVat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WriteLinesInsertVat $parameters
     * @return \StructType\WriteLinesInsertVatResponse|bool
     */
    public function WriteLinesInsertVat(\StructType\WriteLinesInsertVat $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WriteLinesInsertVat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WriteLinesInsertVatResponse|\StructType\WriteLinesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
