<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getDepartments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDepartments $parameters
     * @return \StructType\GetDepartmentsResponse|bool
     */
    public function getDepartments(\StructType\GetDepartments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDepartments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductFile $parameters
     * @return \StructType\GetProductFileResponse|bool
     */
    public function getProductFile(\StructType\GetProductFile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getProductFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomers $parameters
     * @return \StructType\GetCustomersResponse|bool
     */
    public function getCustomers(\StructType\GetCustomers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStockBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStockBalance $parameters
     * @return \StructType\GetStockBalanceResponse|bool
     */
    public function getStockBalance(\StructType\GetStockBalance $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getStockBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVatRates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVatRates $parameters
     * @return \StructType\GetVatRatesResponse|bool
     */
    public function getVatRates(\StructType\GetVatRates $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVatRates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSimplePromotions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSimplePromotions $parameters
     * @return \StructType\GetSimplePromotionsResponse|bool
     */
    public function getSimplePromotions(\StructType\GetSimplePromotions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getSimplePromotions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCustomersResponse|\StructType\GetDepartmentsResponse|\StructType\GetProductFileResponse|\StructType\GetSimplePromotionsResponse|\StructType\GetStockBalanceResponse|\StructType\GetVatRatesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
