<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StartTransaction StructType
 * @subpackage Structs
 */
class StartTransaction extends AbstractStructBase
{
    /**
     * The SaleTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SaleTotal;
    /**
     * The SalesReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesReference;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The Address3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address3;
    /**
     * The Address4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address4;
    /**
     * The Address5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address5;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * The Confirmation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Confirmation;
    /**
     * The AccountCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountCode;
    /**
     * Constructor method for StartTransaction
     * @uses StartTransaction::setSaleTotal()
     * @uses StartTransaction::setSalesReference()
     * @uses StartTransaction::setName()
     * @uses StartTransaction::setAddress1()
     * @uses StartTransaction::setAddress2()
     * @uses StartTransaction::setAddress3()
     * @uses StartTransaction::setAddress4()
     * @uses StartTransaction::setAddress5()
     * @uses StartTransaction::setPhone()
     * @uses StartTransaction::setEmailAddress()
     * @uses StartTransaction::setPaymentType()
     * @uses StartTransaction::setConfirmation()
     * @uses StartTransaction::setAccountCode()
     * @param float $saleTotal
     * @param string $salesReference
     * @param string $name
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $address4
     * @param string $address5
     * @param string $phone
     * @param string $emailAddress
     * @param string $paymentType
     * @param string $confirmation
     * @param string $accountCode
     */
    public function __construct($saleTotal = null, $salesReference = null, $name = null, $address1 = null, $address2 = null, $address3 = null, $address4 = null, $address5 = null, $phone = null, $emailAddress = null, $paymentType = null, $confirmation = null, $accountCode = null)
    {
        $this
            ->setSaleTotal($saleTotal)
            ->setSalesReference($salesReference)
            ->setName($name)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setAddress4($address4)
            ->setAddress5($address5)
            ->setPhone($phone)
            ->setEmailAddress($emailAddress)
            ->setPaymentType($paymentType)
            ->setConfirmation($confirmation)
            ->setAccountCode($accountCode);
    }
    /**
     * Get SaleTotal value
     * @return float
     */
    public function getSaleTotal()
    {
        return $this->SaleTotal;
    }
    /**
     * Set SaleTotal value
     * @param float $saleTotal
     * @return \StructType\StartTransaction
     */
    public function setSaleTotal($saleTotal = null)
    {
        $this->SaleTotal = $saleTotal;
        return $this;
    }
    /**
     * Get SalesReference value
     * @return string|null
     */
    public function getSalesReference()
    {
        return $this->SalesReference;
    }
    /**
     * Set SalesReference value
     * @param string $salesReference
     * @return \StructType\StartTransaction
     */
    public function setSalesReference($salesReference = null)
    {
        // validation for constraint: string
        if (!is_null($salesReference) && !is_string($salesReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesReference)), __LINE__);
        }
        $this->SalesReference = $salesReference;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\StartTransaction
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\StartTransaction
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\StartTransaction
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->Address3;
    }
    /**
     * Set Address3 value
     * @param string $address3
     * @return \StructType\StartTransaction
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address3)), __LINE__);
        }
        $this->Address3 = $address3;
        return $this;
    }
    /**
     * Get Address4 value
     * @return string|null
     */
    public function getAddress4()
    {
        return $this->Address4;
    }
    /**
     * Set Address4 value
     * @param string $address4
     * @return \StructType\StartTransaction
     */
    public function setAddress4($address4 = null)
    {
        // validation for constraint: string
        if (!is_null($address4) && !is_string($address4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address4)), __LINE__);
        }
        $this->Address4 = $address4;
        return $this;
    }
    /**
     * Get Address5 value
     * @return string|null
     */
    public function getAddress5()
    {
        return $this->Address5;
    }
    /**
     * Set Address5 value
     * @param string $address5
     * @return \StructType\StartTransaction
     */
    public function setAddress5($address5 = null)
    {
        // validation for constraint: string
        if (!is_null($address5) && !is_string($address5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address5)), __LINE__);
        }
        $this->Address5 = $address5;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\StartTransaction
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\StartTransaction
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \StructType\StartTransaction
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get Confirmation value
     * @return string|null
     */
    public function getConfirmation()
    {
        return $this->Confirmation;
    }
    /**
     * Set Confirmation value
     * @param string $confirmation
     * @return \StructType\StartTransaction
     */
    public function setConfirmation($confirmation = null)
    {
        // validation for constraint: string
        if (!is_null($confirmation) && !is_string($confirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confirmation)), __LINE__);
        }
        $this->Confirmation = $confirmation;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \StructType\StartTransaction
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCode) && !is_string($accountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountCode)), __LINE__);
        }
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StartTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
