<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getStockBalance StructType
 * @subpackage Structs
 */
class GetStockBalance extends AbstractStructBase
{
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;
    /**
     * The pUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pUser;
    /**
     * The pPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pPassword;
    /**
     * Constructor method for getStockBalance
     * @uses GetStockBalance::setBarcode()
     * @uses GetStockBalance::setPUser()
     * @uses GetStockBalance::setPPassword()
     * @param string $barcode
     * @param string $pUser
     * @param string $pPassword
     */
    public function __construct($barcode = null, $pUser = null, $pPassword = null)
    {
        $this
            ->setBarcode($barcode)
            ->setPUser($pUser)
            ->setPPassword($pPassword);
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\GetStockBalance
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get pUser value
     * @return string|null
     */
    public function getPUser()
    {
        return $this->pUser;
    }
    /**
     * Set pUser value
     * @param string $pUser
     * @return \StructType\GetStockBalance
     */
    public function setPUser($pUser = null)
    {
        // validation for constraint: string
        if (!is_null($pUser) && !is_string($pUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pUser)), __LINE__);
        }
        $this->pUser = $pUser;
        return $this;
    }
    /**
     * Get pPassword value
     * @return string|null
     */
    public function getPPassword()
    {
        return $this->pPassword;
    }
    /**
     * Set pPassword value
     * @param string $pPassword
     * @return \StructType\GetStockBalance
     */
    public function setPPassword($pPassword = null)
    {
        // validation for constraint: string
        if (!is_null($pPassword) && !is_string($pPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pPassword)), __LINE__);
        }
        $this->pPassword = $pPassword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStockBalance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
