<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SortFields StructType
 * Meta informations extracted from the WSDL
 * - type: ns:SortFields
 * @subpackage Structs
 */
class SortFields extends AbstractStructBase
{
    /**
     * The sortField
     * @var int
     */
    public $sortField;
    /**
     * The sortOrder
     * @var int
     */
    public $sortOrder;
    /**
     * Constructor method for SortFields
     * @uses SortFields::setSortField()
     * @uses SortFields::setSortOrder()
     * @param int $sortField
     * @param int $sortOrder
     */
    public function __construct($sortField = null, $sortOrder = null)
    {
        $this
            ->setSortField($sortField)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get sortField value
     * @return int|null
     */
    public function getSortField()
    {
        return $this->sortField;
    }
    /**
     * Set sortField value
     * @param int $sortField
     * @return \StructType\SortFields
     */
    public function setSortField($sortField = null)
    {
        // validation for constraint: int
        if (!is_null($sortField) && !is_numeric($sortField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortField)), __LINE__);
        }
        $this->sortField = $sortField;
        return $this;
    }
    /**
     * Get sortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @param int $sortOrder
     * @return \StructType\SortFields
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SortFields
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
