<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRequest StructType
 * Meta informations extracted from the WSDL
 * - type: ns:ServiceRequest
 * @subpackage Structs
 */
class ServiceRequest extends AbstractStructBase
{
    /**
     * The clientId
     * @var string
     */
    public $clientId;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The format
     * @var string
     */
    public $format;
    /**
     * The from
     * @var int
     */
    public $from;
    /**
     * The indexType
     * @var int
     */
    public $indexType;
    /**
     * The marketSegment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $marketSegment;
    /**
     * The params
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\QueryParameters[]
     */
    public $params;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The requestId
     * @var string
     */
    public $requestId;
    /**
     * The resultView
     * @var int
     */
    public $resultView;
    /**
     * The sortField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SortFields[]
     */
    public $sortField;
    /**
     * The territory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $territory;
    /**
     * The to
     * @var int
     */
    public $to;
    /**
     * Constructor method for ServiceRequest
     * @uses ServiceRequest::setClientId()
     * @uses ServiceRequest::setCurrency()
     * @uses ServiceRequest::setFormat()
     * @uses ServiceRequest::setFrom()
     * @uses ServiceRequest::setIndexType()
     * @uses ServiceRequest::setMarketSegment()
     * @uses ServiceRequest::setParams()
     * @uses ServiceRequest::setPassword()
     * @uses ServiceRequest::setRequestId()
     * @uses ServiceRequest::setResultView()
     * @uses ServiceRequest::setSortField()
     * @uses ServiceRequest::setTerritory()
     * @uses ServiceRequest::setTo()
     * @param string $clientId
     * @param string $currency
     * @param string $format
     * @param int $from
     * @param int $indexType
     * @param string $marketSegment
     * @param \StructType\QueryParameters[] $params
     * @param string $password
     * @param string $requestId
     * @param int $resultView
     * @param \StructType\SortFields[] $sortField
     * @param string $territory
     * @param int $to
     */
    public function __construct($clientId = null, $currency = null, $format = null, $from = null, $indexType = null, $marketSegment = null, array $params = array(), $password = null, $requestId = null, $resultView = null, array $sortField = array(), $territory = null, $to = null)
    {
        $this
            ->setClientId($clientId)
            ->setCurrency($currency)
            ->setFormat($format)
            ->setFrom($from)
            ->setIndexType($indexType)
            ->setMarketSegment($marketSegment)
            ->setParams($params)
            ->setPassword($password)
            ->setRequestId($requestId)
            ->setResultView($resultView)
            ->setSortField($sortField)
            ->setTerritory($territory)
            ->setTo($to);
    }
    /**
     * Get clientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->clientId;
    }
    /**
     * Set clientId value
     * @param string $clientId
     * @return \StructType\ServiceRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientId)), __LINE__);
        }
        $this->clientId = $clientId;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ServiceRequest
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \StructType\ServiceRequest
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get from value
     * @return int|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param int $from
     * @return \StructType\ServiceRequest
     */
    public function setFrom($from = null)
    {
        // validation for constraint: int
        if (!is_null($from) && !is_numeric($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($from)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get indexType value
     * @return int|null
     */
    public function getIndexType()
    {
        return $this->indexType;
    }
    /**
     * Set indexType value
     * @param int $indexType
     * @return \StructType\ServiceRequest
     */
    public function setIndexType($indexType = null)
    {
        // validation for constraint: int
        if (!is_null($indexType) && !is_numeric($indexType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($indexType)), __LINE__);
        }
        $this->indexType = $indexType;
        return $this;
    }
    /**
     * Get marketSegment value
     * @return string|null
     */
    public function getMarketSegment()
    {
        return $this->marketSegment;
    }
    /**
     * Set marketSegment value
     * @param string $marketSegment
     * @return \StructType\ServiceRequest
     */
    public function setMarketSegment($marketSegment = null)
    {
        // validation for constraint: string
        if (!is_null($marketSegment) && !is_string($marketSegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketSegment)), __LINE__);
        }
        $this->marketSegment = $marketSegment;
        return $this;
    }
    /**
     * Get params value
     * @return \StructType\QueryParameters[]|null
     */
    public function getParams()
    {
        return $this->params;
    }
    /**
     * Set params value
     * @throws \InvalidArgumentException
     * @param \StructType\QueryParameters[] $params
     * @return \StructType\ServiceRequest
     */
    public function setParams(array $params = array())
    {
        foreach ($params as $serviceRequestParamsItem) {
            // validation for constraint: itemType
            if (!$serviceRequestParamsItem instanceof \StructType\QueryParameters) {
                throw new \InvalidArgumentException(sprintf('The params property can only contain items of \StructType\QueryParameters, "%s" given', is_object($serviceRequestParamsItem) ? get_class($serviceRequestParamsItem) : gettype($serviceRequestParamsItem)), __LINE__);
            }
        }
        $this->params = $params;
        return $this;
    }
    /**
     * Add item to params value
     * @throws \InvalidArgumentException
     * @param \StructType\QueryParameters $item
     * @return \StructType\ServiceRequest
     */
    public function addToParams(\StructType\QueryParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QueryParameters) {
            throw new \InvalidArgumentException(sprintf('The params property can only contain items of \StructType\QueryParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->params[] = $item;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\ServiceRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get requestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param string $requestId
     * @return \StructType\ServiceRequest
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get resultView value
     * @return int|null
     */
    public function getResultView()
    {
        return $this->resultView;
    }
    /**
     * Set resultView value
     * @param int $resultView
     * @return \StructType\ServiceRequest
     */
    public function setResultView($resultView = null)
    {
        // validation for constraint: int
        if (!is_null($resultView) && !is_numeric($resultView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultView)), __LINE__);
        }
        $this->resultView = $resultView;
        return $this;
    }
    /**
     * Get sortField value
     * @return \StructType\SortFields[]|null
     */
    public function getSortField()
    {
        return $this->sortField;
    }
    /**
     * Set sortField value
     * @throws \InvalidArgumentException
     * @param \StructType\SortFields[] $sortField
     * @return \StructType\ServiceRequest
     */
    public function setSortField(array $sortField = array())
    {
        foreach ($sortField as $serviceRequestSortFieldItem) {
            // validation for constraint: itemType
            if (!$serviceRequestSortFieldItem instanceof \StructType\SortFields) {
                throw new \InvalidArgumentException(sprintf('The sortField property can only contain items of \StructType\SortFields, "%s" given', is_object($serviceRequestSortFieldItem) ? get_class($serviceRequestSortFieldItem) : gettype($serviceRequestSortFieldItem)), __LINE__);
            }
        }
        $this->sortField = $sortField;
        return $this;
    }
    /**
     * Add item to sortField value
     * @throws \InvalidArgumentException
     * @param \StructType\SortFields $item
     * @return \StructType\ServiceRequest
     */
    public function addToSortField(\StructType\SortFields $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SortFields) {
            throw new \InvalidArgumentException(sprintf('The sortField property can only contain items of \StructType\SortFields, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->sortField[] = $item;
        return $this;
    }
    /**
     * Get territory value
     * @return string|null
     */
    public function getTerritory()
    {
        return $this->territory;
    }
    /**
     * Set territory value
     * @param string $territory
     * @return \StructType\ServiceRequest
     */
    public function setTerritory($territory = null)
    {
        // validation for constraint: string
        if (!is_null($territory) && !is_string($territory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($territory)), __LINE__);
        }
        $this->territory = $territory;
        return $this;
    }
    /**
     * Get to value
     * @return int|null
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param int $to
     * @return \StructType\ServiceRequest
     */
    public function setTo($to = null)
    {
        // validation for constraint: int
        if (!is_null($to) && !is_numeric($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($to)), __LINE__);
        }
        $this->to = $to;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
