<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryParameters StructType
 * Meta informations extracted from the WSDL
 * - type: ns:QueryParameters
 * @subpackage Structs
 */
class QueryParameters extends AbstractStructBase
{
    /**
     * The fieldLogic
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BooleanEnum
     */
    public $fieldLogic;
    /**
     * The fieldSearch
     * @var int
     */
    public $fieldSearch;
    /**
     * The fieldValue
     * @var string
     */
    public $fieldValue;
    /**
     * Constructor method for QueryParameters
     * @uses QueryParameters::setFieldLogic()
     * @uses QueryParameters::setFieldSearch()
     * @uses QueryParameters::setFieldValue()
     * @param \StructType\BooleanEnum $fieldLogic
     * @param int $fieldSearch
     * @param string $fieldValue
     */
    public function __construct(\StructType\BooleanEnum $fieldLogic = null, $fieldSearch = null, $fieldValue = null)
    {
        $this
            ->setFieldLogic($fieldLogic)
            ->setFieldSearch($fieldSearch)
            ->setFieldValue($fieldValue);
    }
    /**
     * Get fieldLogic value
     * @return \StructType\BooleanEnum|null
     */
    public function getFieldLogic()
    {
        return $this->fieldLogic;
    }
    /**
     * Set fieldLogic value
     * @param \StructType\BooleanEnum $fieldLogic
     * @return \StructType\QueryParameters
     */
    public function setFieldLogic(\StructType\BooleanEnum $fieldLogic = null)
    {
        $this->fieldLogic = $fieldLogic;
        return $this;
    }
    /**
     * Get fieldSearch value
     * @return int|null
     */
    public function getFieldSearch()
    {
        return $this->fieldSearch;
    }
    /**
     * Set fieldSearch value
     * @param int $fieldSearch
     * @return \StructType\QueryParameters
     */
    public function setFieldSearch($fieldSearch = null)
    {
        // validation for constraint: int
        if (!is_null($fieldSearch) && !is_numeric($fieldSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fieldSearch)), __LINE__);
        }
        $this->fieldSearch = $fieldSearch;
        return $this;
    }
    /**
     * Get fieldValue value
     * @return string|null
     */
    public function getFieldValue()
    {
        return $this->fieldValue;
    }
    /**
     * Set fieldValue value
     * @param string $fieldValue
     * @return \StructType\QueryParameters
     */
    public function setFieldValue($fieldValue = null)
    {
        // validation for constraint: string
        if (!is_null($fieldValue) && !is_string($fieldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fieldValue)), __LINE__);
        }
        $this->fieldValue = $fieldValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QueryParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
