<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BabelWSResult StructType
 * Meta informations extracted from the WSDL
 * - type: ns:BabelWSResult
 * @subpackage Structs
 */
class BabelWSResult extends AbstractStructBase
{
    /**
     * The clientId
     * @var string
     */
    public $clientId;
    /**
     * The format
     * @var string
     */
    public $format;
    /**
     * The hitsFrom
     * @var int
     */
    public $hitsFrom;
    /**
     * The hitsTo
     * @var int
     */
    public $hitsTo;
    /**
     * The requestId
     * @var string
     */
    public $requestId;
    /**
     * The result
     * @var \StructType\Result
     */
    public $result;
    /**
     * The resultCode
     * @var string
     */
    public $resultCode;
    /**
     * The totalHits
     * @var int
     */
    public $totalHits;
    /**
     * Constructor method for BabelWSResult
     * @uses BabelWSResult::setClientId()
     * @uses BabelWSResult::setFormat()
     * @uses BabelWSResult::setHitsFrom()
     * @uses BabelWSResult::setHitsTo()
     * @uses BabelWSResult::setRequestId()
     * @uses BabelWSResult::setResult()
     * @uses BabelWSResult::setResultCode()
     * @uses BabelWSResult::setTotalHits()
     * @param string $clientId
     * @param string $format
     * @param int $hitsFrom
     * @param int $hitsTo
     * @param string $requestId
     * @param \StructType\Result $result
     * @param string $resultCode
     * @param int $totalHits
     */
    public function __construct($clientId = null, $format = null, $hitsFrom = null, $hitsTo = null, $requestId = null, \StructType\Result $result = null, $resultCode = null, $totalHits = null)
    {
        $this
            ->setClientId($clientId)
            ->setFormat($format)
            ->setHitsFrom($hitsFrom)
            ->setHitsTo($hitsTo)
            ->setRequestId($requestId)
            ->setResult($result)
            ->setResultCode($resultCode)
            ->setTotalHits($totalHits);
    }
    /**
     * Get clientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->clientId;
    }
    /**
     * Set clientId value
     * @param string $clientId
     * @return \StructType\BabelWSResult
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientId)), __LINE__);
        }
        $this->clientId = $clientId;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \StructType\BabelWSResult
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get hitsFrom value
     * @return int|null
     */
    public function getHitsFrom()
    {
        return $this->hitsFrom;
    }
    /**
     * Set hitsFrom value
     * @param int $hitsFrom
     * @return \StructType\BabelWSResult
     */
    public function setHitsFrom($hitsFrom = null)
    {
        // validation for constraint: int
        if (!is_null($hitsFrom) && !is_numeric($hitsFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hitsFrom)), __LINE__);
        }
        $this->hitsFrom = $hitsFrom;
        return $this;
    }
    /**
     * Get hitsTo value
     * @return int|null
     */
    public function getHitsTo()
    {
        return $this->hitsTo;
    }
    /**
     * Set hitsTo value
     * @param int $hitsTo
     * @return \StructType\BabelWSResult
     */
    public function setHitsTo($hitsTo = null)
    {
        // validation for constraint: int
        if (!is_null($hitsTo) && !is_numeric($hitsTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hitsTo)), __LINE__);
        }
        $this->hitsTo = $hitsTo;
        return $this;
    }
    /**
     * Get requestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param string $requestId
     * @return \StructType\BabelWSResult
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get result value
     * @return \StructType\Result|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\Result $result
     * @return \StructType\BabelWSResult
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->result = $result;
        return $this;
    }
    /**
     * Get resultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->resultCode;
    }
    /**
     * Set resultCode value
     * @param string $resultCode
     * @return \StructType\BabelWSResult
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultCode)), __LINE__);
        }
        $this->resultCode = $resultCode;
        return $this;
    }
    /**
     * Get totalHits value
     * @return int|null
     */
    public function getTotalHits()
    {
        return $this->totalHits;
    }
    /**
     * Set totalHits value
     * @param int $totalHits
     * @return \StructType\BabelWSResult
     */
    public function setTotalHits($totalHits = null)
    {
        // validation for constraint: int
        if (!is_null($totalHits) && !is_numeric($totalHits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalHits)), __LINE__);
        }
        $this->totalHits = $totalHits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BabelWSResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
