<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Item ServiceType
 * @subpackage Services
 */
class Item extends AbstractSoapClientBase
{
    /**
     * Sets the UserCredentical SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\UserCredentical $userCredentical
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserCredentical(\StructType\UserCredentical $userCredentical, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserCredentical', $userCredentical, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Item_GetStatus
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserCredentical
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\UserCredentical
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Item_GetStatus $parameters
     * @return \StructType\Item_GetStatusResponse|bool
     */
    public function Item_GetStatus(\StructType\Item_GetStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Item_GetStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Item_GetStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
