<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Sets the SendStreamRequestTrackingID SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param string $sendStreamRequestTrackingID
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSendStreamRequestTrackingID(\StructType\Guid $sendStreamRequestTrackingID, $nameSpace = 'http://CargoWise.com/eHub/2010/06', $mustUnderstand = false, $actor = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendStreamRequestTrackingID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sendStreamRequestTrackingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($sendStreamRequestTrackingID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendStreamRequestTrackingID) && !is_string($sendStreamRequestTrackingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendStreamRequestTrackingID)), __LINE__);
        }
        return $this->setSoapHeader($nameSpace, 'SendStreamRequestTrackingID', $sendStreamRequestTrackingID, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessStream
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SendStreamRequestTrackingID
     * - SOAPHeaderNamespaces: http://CargoWise.com/eHub/2010/06
     * - SOAPHeaderTypes: \StructType\Guid
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendStreamRequest $parameters
     * @return \StructType\RetrieveStreamResponse|bool
     */
    public function ProcessStream(\StructType\SendStreamRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessStream($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetrieveStreamResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
