<?php

namespace EnumType;

/**
 * This class stands for MessageSchemaType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MessageSchemaType
 * @subpackage Enumerations
 */
class MessageSchemaType
{
    /**
     * Constant for value 'Xml'
     * @return string 'Xml'
     */
    const VALUE_XML = 'Xml';
    /**
     * Constant for value 'FlatFile'
     * @return string 'FlatFile'
     */
    const VALUE_FLAT_FILE = 'FlatFile';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_XML
     * @uses self::VALUE_FLAT_FILE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_XML,
            self::VALUE_FLAT_FILE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
