<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payload StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Payload
 * @subpackage Structs
 */
class Payload extends AbstractStructBase
{
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EHubGatewayMessage[]
     */
    public $Message;
    /**
     * Constructor method for Payload
     * @uses Payload::setMessage()
     * @param \StructType\EHubGatewayMessage[] $message
     */
    public function __construct(array $message = array())
    {
        $this
            ->setMessage($message);
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EHubGatewayMessage[]|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EHubGatewayMessage[] $message
     * @return \StructType\Payload
     */
    public function setMessage(array $message = array())
    {
        foreach ($message as $payloadMessageItem) {
            // validation for constraint: itemType
            if (!$payloadMessageItem instanceof \StructType\EHubGatewayMessage) {
                throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \StructType\EHubGatewayMessage, "%s" given', is_object($payloadMessageItem) ? get_class($payloadMessageItem) : gettype($payloadMessageItem)), __LINE__);
            }
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Add item to Message value
     * @throws \InvalidArgumentException
     * @param \StructType\EHubGatewayMessage $item
     * @return \StructType\Payload
     */
    public function addToMessage(\StructType\EHubGatewayMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EHubGatewayMessage) {
            throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \StructType\EHubGatewayMessage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Message[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Payload
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
