<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eHubGatewayMessage StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:eHubGatewayMessage
 * @subpackage Structs
 */
class EHubGatewayMessage extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The ApplicationCode
     * @var string
     */
    public $ApplicationCode;
    /**
     * The ClientID
     * @var string
     */
    public $ClientID;
    /**
     * The EmailSubject
     * @var string
     */
    public $EmailSubject;
    /**
     * The FileName
     * @var string
     */
    public $FileName;
    /**
     * The TrackingID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TrackingID;
    /**
     * The SchemaName
     * @var string
     */
    public $SchemaName;
    /**
     * The SchemaType
     * @var string
     */
    public $SchemaType;
    /**
     * Constructor method for eHubGatewayMessage
     * @uses EHubGatewayMessage::set_()
     * @uses EHubGatewayMessage::setApplicationCode()
     * @uses EHubGatewayMessage::setClientID()
     * @uses EHubGatewayMessage::setEmailSubject()
     * @uses EHubGatewayMessage::setFileName()
     * @uses EHubGatewayMessage::setTrackingID()
     * @uses EHubGatewayMessage::setSchemaName()
     * @uses EHubGatewayMessage::setSchemaType()
     * @param string $_
     * @param string $applicationCode
     * @param string $clientID
     * @param string $emailSubject
     * @param string $fileName
     * @param string $trackingID
     * @param string $schemaName
     * @param string $schemaType
     */
    public function __construct($_ = null, $applicationCode = null, $clientID = null, $emailSubject = null, $fileName = null, $trackingID = null, $schemaName = null, $schemaType = null)
    {
        $this
            ->set_($_)
            ->setApplicationCode($applicationCode)
            ->setClientID($clientID)
            ->setEmailSubject($emailSubject)
            ->setFileName($fileName)
            ->setTrackingID($trackingID)
            ->setSchemaName($schemaName)
            ->setSchemaType($schemaType);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\EHubGatewayMessage
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ApplicationCode value
     * @return string|null
     */
    public function getApplicationCode()
    {
        return $this->ApplicationCode;
    }
    /**
     * Set ApplicationCode value
     * @param string $applicationCode
     * @return \StructType\EHubGatewayMessage
     */
    public function setApplicationCode($applicationCode = null)
    {
        // validation for constraint: string
        if (!is_null($applicationCode) && !is_string($applicationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationCode)), __LINE__);
        }
        $this->ApplicationCode = $applicationCode;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\EHubGatewayMessage
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get EmailSubject value
     * @return string|null
     */
    public function getEmailSubject()
    {
        return $this->EmailSubject;
    }
    /**
     * Set EmailSubject value
     * @param string $emailSubject
     * @return \StructType\EHubGatewayMessage
     */
    public function setEmailSubject($emailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($emailSubject) && !is_string($emailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailSubject)), __LINE__);
        }
        $this->EmailSubject = $emailSubject;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\EHubGatewayMessage
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get TrackingID value
     * @return string|null
     */
    public function getTrackingID()
    {
        return $this->TrackingID;
    }
    /**
     * Set TrackingID value
     * @param string $trackingID
     * @return \StructType\EHubGatewayMessage
     */
    public function setTrackingID($trackingID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($trackingID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $trackingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($trackingID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($trackingID) && !is_string($trackingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingID)), __LINE__);
        }
        $this->TrackingID = $trackingID;
        return $this;
    }
    /**
     * Get SchemaName value
     * @return string|null
     */
    public function getSchemaName()
    {
        return $this->SchemaName;
    }
    /**
     * Set SchemaName value
     * @param string $schemaName
     * @return \StructType\EHubGatewayMessage
     */
    public function setSchemaName($schemaName = null)
    {
        // validation for constraint: string
        if (!is_null($schemaName) && !is_string($schemaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schemaName)), __LINE__);
        }
        $this->SchemaName = $schemaName;
        return $this;
    }
    /**
     * Get SchemaType value
     * @return string|null
     */
    public function getSchemaType()
    {
        return $this->SchemaType;
    }
    /**
     * Set SchemaType value
     * @uses \EnumType\MessageSchemaType::valueIsValid()
     * @uses \EnumType\MessageSchemaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schemaType
     * @return \StructType\EHubGatewayMessage
     */
    public function setSchemaType($schemaType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageSchemaType::valueIsValid($schemaType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $schemaType, implode(', ', \EnumType\MessageSchemaType::getValidValues())), __LINE__);
        }
        $this->SchemaType = $schemaType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EHubGatewayMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
