<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Capture ServiceType
 * @subpackage Services
 */
class Capture extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Capture_Interactive_Find_v1_00
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Capture_Interactive_Find_v1_00 $parameters
     * @return \StructType\Capture_Interactive_Find_v1_00_Response|bool
     */
    public function Capture_Interactive_Find_v1_00(\StructType\Capture_Interactive_Find_v1_00 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Capture_Interactive_Find_v1_00($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Capture_Interactive_Find_v1_00_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
