<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WalletAccountResponse StructType
 * @subpackage Structs
 */
class WalletAccountResponse extends AbstractStructBase
{
    /**
     * The WalletType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WalletType;
    /**
     * The WalletAccountDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WalletAccountDisplay;
    /**
     * Constructor method for WalletAccountResponse
     * @uses WalletAccountResponse::setWalletType()
     * @uses WalletAccountResponse::setWalletAccountDisplay()
     * @param int $walletType
     * @param string $walletAccountDisplay
     */
    public function __construct($walletType = null, $walletAccountDisplay = null)
    {
        $this
            ->setWalletType($walletType)
            ->setWalletAccountDisplay($walletAccountDisplay);
    }
    /**
     * Get WalletType value
     * @return int
     */
    public function getWalletType()
    {
        return $this->WalletType;
    }
    /**
     * Set WalletType value
     * @param int $walletType
     * @return \StructType\WalletAccountResponse
     */
    public function setWalletType($walletType = null)
    {
        // validation for constraint: int
        if (!is_null($walletType) && !is_numeric($walletType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($walletType)), __LINE__);
        }
        $this->WalletType = $walletType;
        return $this;
    }
    /**
     * Get WalletAccountDisplay value
     * @return string|null
     */
    public function getWalletAccountDisplay()
    {
        return $this->WalletAccountDisplay;
    }
    /**
     * Set WalletAccountDisplay value
     * @param string $walletAccountDisplay
     * @return \StructType\WalletAccountResponse
     */
    public function setWalletAccountDisplay($walletAccountDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($walletAccountDisplay) && !is_string($walletAccountDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($walletAccountDisplay)), __LINE__);
        }
        $this->WalletAccountDisplay = $walletAccountDisplay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WalletAccountResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
