<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePartyRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:UpdatePartyRequest
 * @subpackage Structs
 */
class UpdatePartyRequest extends ApiRequest
{
    /**
     * The PartyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PartyID;
    /**
     * The PartyType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PartyType;
    /**
     * The PartyStatusType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PartyStatusType;
    /**
     * The HostID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $HostID;
    /**
     * The DistributorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DistributorID;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The CloseDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CloseDate;
    /**
     * The EventStart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EventStart;
    /**
     * The EventEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EventEnd;
    /**
     * The LanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $LanguageID;
    /**
     * The BookingPartyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BookingPartyID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Information
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Information;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PartyAddress
     */
    public $Address;
    /**
     * The Field1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field1;
    /**
     * The Field2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field2;
    /**
     * The Field3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field3;
    /**
     * The Field4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field4;
    /**
     * The Field5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field5;
    /**
     * Constructor method for UpdatePartyRequest
     * @uses UpdatePartyRequest::setPartyID()
     * @uses UpdatePartyRequest::setPartyType()
     * @uses UpdatePartyRequest::setPartyStatusType()
     * @uses UpdatePartyRequest::setHostID()
     * @uses UpdatePartyRequest::setDistributorID()
     * @uses UpdatePartyRequest::setStartDate()
     * @uses UpdatePartyRequest::setCloseDate()
     * @uses UpdatePartyRequest::setEventStart()
     * @uses UpdatePartyRequest::setEventEnd()
     * @uses UpdatePartyRequest::setLanguageID()
     * @uses UpdatePartyRequest::setBookingPartyID()
     * @uses UpdatePartyRequest::setDescription()
     * @uses UpdatePartyRequest::setInformation()
     * @uses UpdatePartyRequest::setAddress()
     * @uses UpdatePartyRequest::setField1()
     * @uses UpdatePartyRequest::setField2()
     * @uses UpdatePartyRequest::setField3()
     * @uses UpdatePartyRequest::setField4()
     * @uses UpdatePartyRequest::setField5()
     * @param int $partyID
     * @param int $partyType
     * @param int $partyStatusType
     * @param int $hostID
     * @param int $distributorID
     * @param string $startDate
     * @param string $closeDate
     * @param string $eventStart
     * @param string $eventEnd
     * @param int $languageID
     * @param int $bookingPartyID
     * @param string $description
     * @param string $information
     * @param \StructType\PartyAddress $address
     * @param string $field1
     * @param string $field2
     * @param string $field3
     * @param string $field4
     * @param string $field5
     */
    public function __construct($partyID = null, $partyType = null, $partyStatusType = null, $hostID = null, $distributorID = null, $startDate = null, $closeDate = null, $eventStart = null, $eventEnd = null, $languageID = null, $bookingPartyID = null, $description = null, $information = null, \StructType\PartyAddress $address = null, $field1 = null, $field2 = null, $field3 = null, $field4 = null, $field5 = null)
    {
        $this
            ->setPartyID($partyID)
            ->setPartyType($partyType)
            ->setPartyStatusType($partyStatusType)
            ->setHostID($hostID)
            ->setDistributorID($distributorID)
            ->setStartDate($startDate)
            ->setCloseDate($closeDate)
            ->setEventStart($eventStart)
            ->setEventEnd($eventEnd)
            ->setLanguageID($languageID)
            ->setBookingPartyID($bookingPartyID)
            ->setDescription($description)
            ->setInformation($information)
            ->setAddress($address)
            ->setField1($field1)
            ->setField2($field2)
            ->setField3($field3)
            ->setField4($field4)
            ->setField5($field5);
    }
    /**
     * Get PartyID value
     * @return int
     */
    public function getPartyID()
    {
        return $this->PartyID;
    }
    /**
     * Set PartyID value
     * @param int $partyID
     * @return \StructType\UpdatePartyRequest
     */
    public function setPartyID($partyID = null)
    {
        // validation for constraint: int
        if (!is_null($partyID) && !is_numeric($partyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partyID)), __LINE__);
        }
        $this->PartyID = $partyID;
        return $this;
    }
    /**
     * Get PartyType value
     * @return int
     */
    public function getPartyType()
    {
        return $this->PartyType;
    }
    /**
     * Set PartyType value
     * @param int $partyType
     * @return \StructType\UpdatePartyRequest
     */
    public function setPartyType($partyType = null)
    {
        // validation for constraint: int
        if (!is_null($partyType) && !is_numeric($partyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partyType)), __LINE__);
        }
        $this->PartyType = $partyType;
        return $this;
    }
    /**
     * Get PartyStatusType value
     * @return int
     */
    public function getPartyStatusType()
    {
        return $this->PartyStatusType;
    }
    /**
     * Set PartyStatusType value
     * @param int $partyStatusType
     * @return \StructType\UpdatePartyRequest
     */
    public function setPartyStatusType($partyStatusType = null)
    {
        // validation for constraint: int
        if (!is_null($partyStatusType) && !is_numeric($partyStatusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partyStatusType)), __LINE__);
        }
        $this->PartyStatusType = $partyStatusType;
        return $this;
    }
    /**
     * Get HostID value
     * @return int
     */
    public function getHostID()
    {
        return $this->HostID;
    }
    /**
     * Set HostID value
     * @param int $hostID
     * @return \StructType\UpdatePartyRequest
     */
    public function setHostID($hostID = null)
    {
        // validation for constraint: int
        if (!is_null($hostID) && !is_numeric($hostID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hostID)), __LINE__);
        }
        $this->HostID = $hostID;
        return $this;
    }
    /**
     * Get DistributorID value
     * @return int
     */
    public function getDistributorID()
    {
        return $this->DistributorID;
    }
    /**
     * Set DistributorID value
     * @param int $distributorID
     * @return \StructType\UpdatePartyRequest
     */
    public function setDistributorID($distributorID = null)
    {
        // validation for constraint: int
        if (!is_null($distributorID) && !is_numeric($distributorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributorID)), __LINE__);
        }
        $this->DistributorID = $distributorID;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\UpdatePartyRequest
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get CloseDate value
     * @return string
     */
    public function getCloseDate()
    {
        return $this->CloseDate;
    }
    /**
     * Set CloseDate value
     * @param string $closeDate
     * @return \StructType\UpdatePartyRequest
     */
    public function setCloseDate($closeDate = null)
    {
        // validation for constraint: string
        if (!is_null($closeDate) && !is_string($closeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closeDate)), __LINE__);
        }
        $this->CloseDate = $closeDate;
        return $this;
    }
    /**
     * Get EventStart value
     * @return string
     */
    public function getEventStart()
    {
        return $this->EventStart;
    }
    /**
     * Set EventStart value
     * @param string $eventStart
     * @return \StructType\UpdatePartyRequest
     */
    public function setEventStart($eventStart = null)
    {
        // validation for constraint: string
        if (!is_null($eventStart) && !is_string($eventStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventStart)), __LINE__);
        }
        $this->EventStart = $eventStart;
        return $this;
    }
    /**
     * Get EventEnd value
     * @return string
     */
    public function getEventEnd()
    {
        return $this->EventEnd;
    }
    /**
     * Set EventEnd value
     * @param string $eventEnd
     * @return \StructType\UpdatePartyRequest
     */
    public function setEventEnd($eventEnd = null)
    {
        // validation for constraint: string
        if (!is_null($eventEnd) && !is_string($eventEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventEnd)), __LINE__);
        }
        $this->EventEnd = $eventEnd;
        return $this;
    }
    /**
     * Get LanguageID value
     * @return int
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \StructType\UpdatePartyRequest
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !is_numeric($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get BookingPartyID value
     * @return int
     */
    public function getBookingPartyID()
    {
        return $this->BookingPartyID;
    }
    /**
     * Set BookingPartyID value
     * @param int $bookingPartyID
     * @return \StructType\UpdatePartyRequest
     */
    public function setBookingPartyID($bookingPartyID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingPartyID) && !is_numeric($bookingPartyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bookingPartyID)), __LINE__);
        }
        $this->BookingPartyID = $bookingPartyID;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\UpdatePartyRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Information value
     * @return string|null
     */
    public function getInformation()
    {
        return $this->Information;
    }
    /**
     * Set Information value
     * @param string $information
     * @return \StructType\UpdatePartyRequest
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($information)), __LINE__);
        }
        $this->Information = $information;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\PartyAddress|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\PartyAddress $address
     * @return \StructType\UpdatePartyRequest
     */
    public function setAddress(\StructType\PartyAddress $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Field1 value
     * @return string|null
     */
    public function getField1()
    {
        return $this->Field1;
    }
    /**
     * Set Field1 value
     * @param string $field1
     * @return \StructType\UpdatePartyRequest
     */
    public function setField1($field1 = null)
    {
        // validation for constraint: string
        if (!is_null($field1) && !is_string($field1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field1)), __LINE__);
        }
        $this->Field1 = $field1;
        return $this;
    }
    /**
     * Get Field2 value
     * @return string|null
     */
    public function getField2()
    {
        return $this->Field2;
    }
    /**
     * Set Field2 value
     * @param string $field2
     * @return \StructType\UpdatePartyRequest
     */
    public function setField2($field2 = null)
    {
        // validation for constraint: string
        if (!is_null($field2) && !is_string($field2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field2)), __LINE__);
        }
        $this->Field2 = $field2;
        return $this;
    }
    /**
     * Get Field3 value
     * @return string|null
     */
    public function getField3()
    {
        return $this->Field3;
    }
    /**
     * Set Field3 value
     * @param string $field3
     * @return \StructType\UpdatePartyRequest
     */
    public function setField3($field3 = null)
    {
        // validation for constraint: string
        if (!is_null($field3) && !is_string($field3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field3)), __LINE__);
        }
        $this->Field3 = $field3;
        return $this;
    }
    /**
     * Get Field4 value
     * @return string|null
     */
    public function getField4()
    {
        return $this->Field4;
    }
    /**
     * Set Field4 value
     * @param string $field4
     * @return \StructType\UpdatePartyRequest
     */
    public function setField4($field4 = null)
    {
        // validation for constraint: string
        if (!is_null($field4) && !is_string($field4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field4)), __LINE__);
        }
        $this->Field4 = $field4;
        return $this;
    }
    /**
     * Get Field5 value
     * @return string|null
     */
    public function getField5()
    {
        return $this->Field5;
    }
    /**
     * Set Field5 value
     * @param string $field5
     * @return \StructType\UpdatePartyRequest
     */
    public function setField5($field5 = null)
    {
        // validation for constraint: string
        if (!is_null($field5) && !is_string($field5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field5)), __LINE__);
        }
        $this->Field5 = $field5;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdatePartyRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
