<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCalendarItemRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:UpdateCalendarItemRequest
 * @subpackage Structs
 */
class UpdateCalendarItemRequest extends ApiRequest
{
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The CalendarID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CalendarID;
    /**
     * The CalendarItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CalendarItemID;
    /**
     * The CalendarItemType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CalendarItemType;
    /**
     * The CalendarItemStatusType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CalendarItemStatusType;
    /**
     * The CalendarItemPriorityType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CalendarItemPriorityType;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The TimeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TimeZone;
    /**
     * The ContactPhoneType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ContactPhoneType;
    /**
     * The IsShared
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsShared;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Location;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The ContactInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactInfo;
    /**
     * The ContactPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactPhone;
    /**
     * The ContactEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactEmail;
    /**
     * The EventHost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventHost;
    /**
     * The SpecialGuests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SpecialGuests;
    /**
     * The EventFlyer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventFlyer;
    /**
     * The EventCostInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventCostInfo;
    /**
     * The EventConferenceCallOrWebinar
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventConferenceCallOrWebinar;
    /**
     * The EventRegistrationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventRegistrationInfo;
    /**
     * The EventTags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventTags;
    /**
     * Constructor method for UpdateCalendarItemRequest
     * @uses UpdateCalendarItemRequest::setUserID()
     * @uses UpdateCalendarItemRequest::setCalendarID()
     * @uses UpdateCalendarItemRequest::setCalendarItemID()
     * @uses UpdateCalendarItemRequest::setCalendarItemType()
     * @uses UpdateCalendarItemRequest::setCalendarItemStatusType()
     * @uses UpdateCalendarItemRequest::setCalendarItemPriorityType()
     * @uses UpdateCalendarItemRequest::setStartDate()
     * @uses UpdateCalendarItemRequest::setEndDate()
     * @uses UpdateCalendarItemRequest::setTimeZone()
     * @uses UpdateCalendarItemRequest::setContactPhoneType()
     * @uses UpdateCalendarItemRequest::setIsShared()
     * @uses UpdateCalendarItemRequest::setSubject()
     * @uses UpdateCalendarItemRequest::setLocation()
     * @uses UpdateCalendarItemRequest::setNotes()
     * @uses UpdateCalendarItemRequest::setAddress1()
     * @uses UpdateCalendarItemRequest::setAddress2()
     * @uses UpdateCalendarItemRequest::setCity()
     * @uses UpdateCalendarItemRequest::setState()
     * @uses UpdateCalendarItemRequest::setCountry()
     * @uses UpdateCalendarItemRequest::setPostalCode()
     * @uses UpdateCalendarItemRequest::setContactInfo()
     * @uses UpdateCalendarItemRequest::setContactPhone()
     * @uses UpdateCalendarItemRequest::setContactEmail()
     * @uses UpdateCalendarItemRequest::setEventHost()
     * @uses UpdateCalendarItemRequest::setSpecialGuests()
     * @uses UpdateCalendarItemRequest::setEventFlyer()
     * @uses UpdateCalendarItemRequest::setEventCostInfo()
     * @uses UpdateCalendarItemRequest::setEventConferenceCallOrWebinar()
     * @uses UpdateCalendarItemRequest::setEventRegistrationInfo()
     * @uses UpdateCalendarItemRequest::setEventTags()
     * @param int $userID
     * @param int $calendarID
     * @param int $calendarItemID
     * @param string $calendarItemType
     * @param string $calendarItemStatusType
     * @param string $calendarItemPriorityType
     * @param string $startDate
     * @param string $endDate
     * @param int $timeZone
     * @param string $contactPhoneType
     * @param bool $isShared
     * @param string $subject
     * @param string $location
     * @param string $notes
     * @param string $address1
     * @param string $address2
     * @param string $city
     * @param string $state
     * @param string $country
     * @param string $postalCode
     * @param string $contactInfo
     * @param string $contactPhone
     * @param string $contactEmail
     * @param string $eventHost
     * @param string $specialGuests
     * @param string $eventFlyer
     * @param string $eventCostInfo
     * @param string $eventConferenceCallOrWebinar
     * @param string $eventRegistrationInfo
     * @param string $eventTags
     */
    public function __construct($userID = null, $calendarID = null, $calendarItemID = null, $calendarItemType = null, $calendarItemStatusType = null, $calendarItemPriorityType = null, $startDate = null, $endDate = null, $timeZone = null, $contactPhoneType = null, $isShared = null, $subject = null, $location = null, $notes = null, $address1 = null, $address2 = null, $city = null, $state = null, $country = null, $postalCode = null, $contactInfo = null, $contactPhone = null, $contactEmail = null, $eventHost = null, $specialGuests = null, $eventFlyer = null, $eventCostInfo = null, $eventConferenceCallOrWebinar = null, $eventRegistrationInfo = null, $eventTags = null)
    {
        $this
            ->setUserID($userID)
            ->setCalendarID($calendarID)
            ->setCalendarItemID($calendarItemID)
            ->setCalendarItemType($calendarItemType)
            ->setCalendarItemStatusType($calendarItemStatusType)
            ->setCalendarItemPriorityType($calendarItemPriorityType)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setTimeZone($timeZone)
            ->setContactPhoneType($contactPhoneType)
            ->setIsShared($isShared)
            ->setSubject($subject)
            ->setLocation($location)
            ->setNotes($notes)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCity($city)
            ->setState($state)
            ->setCountry($country)
            ->setPostalCode($postalCode)
            ->setContactInfo($contactInfo)
            ->setContactPhone($contactPhone)
            ->setContactEmail($contactEmail)
            ->setEventHost($eventHost)
            ->setSpecialGuests($specialGuests)
            ->setEventFlyer($eventFlyer)
            ->setEventCostInfo($eventCostInfo)
            ->setEventConferenceCallOrWebinar($eventConferenceCallOrWebinar)
            ->setEventRegistrationInfo($eventRegistrationInfo)
            ->setEventTags($eventTags);
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get CalendarID value
     * @return int
     */
    public function getCalendarID()
    {
        return $this->CalendarID;
    }
    /**
     * Set CalendarID value
     * @param int $calendarID
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setCalendarID($calendarID = null)
    {
        // validation for constraint: int
        if (!is_null($calendarID) && !is_numeric($calendarID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($calendarID)), __LINE__);
        }
        $this->CalendarID = $calendarID;
        return $this;
    }
    /**
     * Get CalendarItemID value
     * @return int
     */
    public function getCalendarItemID()
    {
        return $this->CalendarItemID;
    }
    /**
     * Set CalendarItemID value
     * @param int $calendarItemID
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setCalendarItemID($calendarItemID = null)
    {
        // validation for constraint: int
        if (!is_null($calendarItemID) && !is_numeric($calendarItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($calendarItemID)), __LINE__);
        }
        $this->CalendarItemID = $calendarItemID;
        return $this;
    }
    /**
     * Get CalendarItemType value
     * @return string
     */
    public function getCalendarItemType()
    {
        return $this->CalendarItemType;
    }
    /**
     * Set CalendarItemType value
     * @uses \EnumType\CalendarItemType::valueIsValid()
     * @uses \EnumType\CalendarItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calendarItemType
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setCalendarItemType($calendarItemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CalendarItemType::valueIsValid($calendarItemType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calendarItemType, implode(', ', \EnumType\CalendarItemType::getValidValues())), __LINE__);
        }
        $this->CalendarItemType = $calendarItemType;
        return $this;
    }
    /**
     * Get CalendarItemStatusType value
     * @return string
     */
    public function getCalendarItemStatusType()
    {
        return $this->CalendarItemStatusType;
    }
    /**
     * Set CalendarItemStatusType value
     * @uses \EnumType\CalendarItemStatusType::valueIsValid()
     * @uses \EnumType\CalendarItemStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calendarItemStatusType
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setCalendarItemStatusType($calendarItemStatusType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CalendarItemStatusType::valueIsValid($calendarItemStatusType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calendarItemStatusType, implode(', ', \EnumType\CalendarItemStatusType::getValidValues())), __LINE__);
        }
        $this->CalendarItemStatusType = $calendarItemStatusType;
        return $this;
    }
    /**
     * Get CalendarItemPriorityType value
     * @return string
     */
    public function getCalendarItemPriorityType()
    {
        return $this->CalendarItemPriorityType;
    }
    /**
     * Set CalendarItemPriorityType value
     * @uses \EnumType\CalendarItemPriorityType::valueIsValid()
     * @uses \EnumType\CalendarItemPriorityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calendarItemPriorityType
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setCalendarItemPriorityType($calendarItemPriorityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CalendarItemPriorityType::valueIsValid($calendarItemPriorityType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calendarItemPriorityType, implode(', ', \EnumType\CalendarItemPriorityType::getValidValues())), __LINE__);
        }
        $this->CalendarItemPriorityType = $calendarItemPriorityType;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get TimeZone value
     * @return int
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @param int $timeZone
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: int
        if (!is_null($timeZone) && !is_numeric($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timeZone)), __LINE__);
        }
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Get ContactPhoneType value
     * @return string
     */
    public function getContactPhoneType()
    {
        return $this->ContactPhoneType;
    }
    /**
     * Set ContactPhoneType value
     * @uses \EnumType\ContactPhoneType::valueIsValid()
     * @uses \EnumType\ContactPhoneType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contactPhoneType
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setContactPhoneType($contactPhoneType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactPhoneType::valueIsValid($contactPhoneType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $contactPhoneType, implode(', ', \EnumType\ContactPhoneType::getValidValues())), __LINE__);
        }
        $this->ContactPhoneType = $contactPhoneType;
        return $this;
    }
    /**
     * Get IsShared value
     * @return bool
     */
    public function getIsShared()
    {
        return $this->IsShared;
    }
    /**
     * Set IsShared value
     * @param bool $isShared
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setIsShared($isShared = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShared) && !is_bool($isShared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isShared)), __LINE__);
        }
        $this->IsShared = $isShared;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return string|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param string $contactInfo
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setContactInfo($contactInfo = null)
    {
        // validation for constraint: string
        if (!is_null($contactInfo) && !is_string($contactInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactInfo)), __LINE__);
        }
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get ContactPhone value
     * @return string|null
     */
    public function getContactPhone()
    {
        return $this->ContactPhone;
    }
    /**
     * Set ContactPhone value
     * @param string $contactPhone
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setContactPhone($contactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($contactPhone) && !is_string($contactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactPhone)), __LINE__);
        }
        $this->ContactPhone = $contactPhone;
        return $this;
    }
    /**
     * Get ContactEmail value
     * @return string|null
     */
    public function getContactEmail()
    {
        return $this->ContactEmail;
    }
    /**
     * Set ContactEmail value
     * @param string $contactEmail
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setContactEmail($contactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmail) && !is_string($contactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactEmail)), __LINE__);
        }
        $this->ContactEmail = $contactEmail;
        return $this;
    }
    /**
     * Get EventHost value
     * @return string|null
     */
    public function getEventHost()
    {
        return $this->EventHost;
    }
    /**
     * Set EventHost value
     * @param string $eventHost
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setEventHost($eventHost = null)
    {
        // validation for constraint: string
        if (!is_null($eventHost) && !is_string($eventHost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventHost)), __LINE__);
        }
        $this->EventHost = $eventHost;
        return $this;
    }
    /**
     * Get SpecialGuests value
     * @return string|null
     */
    public function getSpecialGuests()
    {
        return $this->SpecialGuests;
    }
    /**
     * Set SpecialGuests value
     * @param string $specialGuests
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setSpecialGuests($specialGuests = null)
    {
        // validation for constraint: string
        if (!is_null($specialGuests) && !is_string($specialGuests)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($specialGuests)), __LINE__);
        }
        $this->SpecialGuests = $specialGuests;
        return $this;
    }
    /**
     * Get EventFlyer value
     * @return string|null
     */
    public function getEventFlyer()
    {
        return $this->EventFlyer;
    }
    /**
     * Set EventFlyer value
     * @param string $eventFlyer
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setEventFlyer($eventFlyer = null)
    {
        // validation for constraint: string
        if (!is_null($eventFlyer) && !is_string($eventFlyer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventFlyer)), __LINE__);
        }
        $this->EventFlyer = $eventFlyer;
        return $this;
    }
    /**
     * Get EventCostInfo value
     * @return string|null
     */
    public function getEventCostInfo()
    {
        return $this->EventCostInfo;
    }
    /**
     * Set EventCostInfo value
     * @param string $eventCostInfo
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setEventCostInfo($eventCostInfo = null)
    {
        // validation for constraint: string
        if (!is_null($eventCostInfo) && !is_string($eventCostInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventCostInfo)), __LINE__);
        }
        $this->EventCostInfo = $eventCostInfo;
        return $this;
    }
    /**
     * Get EventConferenceCallOrWebinar value
     * @return string|null
     */
    public function getEventConferenceCallOrWebinar()
    {
        return $this->EventConferenceCallOrWebinar;
    }
    /**
     * Set EventConferenceCallOrWebinar value
     * @param string $eventConferenceCallOrWebinar
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setEventConferenceCallOrWebinar($eventConferenceCallOrWebinar = null)
    {
        // validation for constraint: string
        if (!is_null($eventConferenceCallOrWebinar) && !is_string($eventConferenceCallOrWebinar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventConferenceCallOrWebinar)), __LINE__);
        }
        $this->EventConferenceCallOrWebinar = $eventConferenceCallOrWebinar;
        return $this;
    }
    /**
     * Get EventRegistrationInfo value
     * @return string|null
     */
    public function getEventRegistrationInfo()
    {
        return $this->EventRegistrationInfo;
    }
    /**
     * Set EventRegistrationInfo value
     * @param string $eventRegistrationInfo
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setEventRegistrationInfo($eventRegistrationInfo = null)
    {
        // validation for constraint: string
        if (!is_null($eventRegistrationInfo) && !is_string($eventRegistrationInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventRegistrationInfo)), __LINE__);
        }
        $this->EventRegistrationInfo = $eventRegistrationInfo;
        return $this;
    }
    /**
     * Get EventTags value
     * @return string|null
     */
    public function getEventTags()
    {
        return $this->EventTags;
    }
    /**
     * Set EventTags value
     * @param string $eventTags
     * @return \StructType\UpdateCalendarItemRequest
     */
    public function setEventTags($eventTags = null)
    {
        // validation for constraint: string
        if (!is_null($eventTags) && !is_string($eventTags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventTags)), __LINE__);
        }
        $this->EventTags = $eventTags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCalendarItemRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
