<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAutoOrderDetailRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:UpdateAutoOrderDetailRequest
 * @subpackage Structs
 */
class UpdateAutoOrderDetailRequest extends ApiRequest
{
    /**
     * The AutoOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AutoOrderID;
    /**
     * The OrderLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderLine;
    /**
     * The ItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemID;
    /**
     * The Qty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Qty;
    /**
     * The ManualPriceEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ManualPriceEach;
    /**
     * The ManualTaxablePriceEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ManualTaxablePriceEach;
    /**
     * The ManualShippingPriceEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ManualShippingPriceEach;
    /**
     * The ManualBVEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ManualBVEach;
    /**
     * The ManualCVEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ManualCVEach;
    /**
     * The PeriodDescriptionTy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PeriodDescriptionTy;
    /**
     * The PriceEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PriceEach;
    /**
     * The PriceExt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PriceExt;
    /**
     * The BVEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BVEach;
    /**
     * The BusinessVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BusinessVolume;
    /**
     * The CVEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CVEach;
    /**
     * The CommissionableVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CommissionableVolume;
    /**
     * The DynamicKitItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DynamicKitItemID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Reference1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference1;
    /**
     * Constructor method for UpdateAutoOrderDetailRequest
     * @uses UpdateAutoOrderDetailRequest::setAutoOrderID()
     * @uses UpdateAutoOrderDetailRequest::setOrderLine()
     * @uses UpdateAutoOrderDetailRequest::setItemID()
     * @uses UpdateAutoOrderDetailRequest::setQty()
     * @uses UpdateAutoOrderDetailRequest::setManualPriceEach()
     * @uses UpdateAutoOrderDetailRequest::setManualTaxablePriceEach()
     * @uses UpdateAutoOrderDetailRequest::setManualShippingPriceEach()
     * @uses UpdateAutoOrderDetailRequest::setManualBVEach()
     * @uses UpdateAutoOrderDetailRequest::setManualCVEach()
     * @uses UpdateAutoOrderDetailRequest::setPeriodDescriptionTy()
     * @uses UpdateAutoOrderDetailRequest::setPriceEach()
     * @uses UpdateAutoOrderDetailRequest::setPriceExt()
     * @uses UpdateAutoOrderDetailRequest::setBVEach()
     * @uses UpdateAutoOrderDetailRequest::setBusinessVolume()
     * @uses UpdateAutoOrderDetailRequest::setCVEach()
     * @uses UpdateAutoOrderDetailRequest::setCommissionableVolume()
     * @uses UpdateAutoOrderDetailRequest::setDynamicKitItemID()
     * @uses UpdateAutoOrderDetailRequest::setDescription()
     * @uses UpdateAutoOrderDetailRequest::setReference1()
     * @param int $autoOrderID
     * @param int $orderLine
     * @param int $itemID
     * @param float $qty
     * @param float $manualPriceEach
     * @param float $manualTaxablePriceEach
     * @param float $manualShippingPriceEach
     * @param float $manualBVEach
     * @param float $manualCVEach
     * @param int $periodDescriptionTy
     * @param float $priceEach
     * @param float $priceExt
     * @param float $bVEach
     * @param float $businessVolume
     * @param float $cVEach
     * @param float $commissionableVolume
     * @param int $dynamicKitItemID
     * @param string $description
     * @param string $reference1
     */
    public function __construct($autoOrderID = null, $orderLine = null, $itemID = null, $qty = null, $manualPriceEach = null, $manualTaxablePriceEach = null, $manualShippingPriceEach = null, $manualBVEach = null, $manualCVEach = null, $periodDescriptionTy = null, $priceEach = null, $priceExt = null, $bVEach = null, $businessVolume = null, $cVEach = null, $commissionableVolume = null, $dynamicKitItemID = null, $description = null, $reference1 = null)
    {
        $this
            ->setAutoOrderID($autoOrderID)
            ->setOrderLine($orderLine)
            ->setItemID($itemID)
            ->setQty($qty)
            ->setManualPriceEach($manualPriceEach)
            ->setManualTaxablePriceEach($manualTaxablePriceEach)
            ->setManualShippingPriceEach($manualShippingPriceEach)
            ->setManualBVEach($manualBVEach)
            ->setManualCVEach($manualCVEach)
            ->setPeriodDescriptionTy($periodDescriptionTy)
            ->setPriceEach($priceEach)
            ->setPriceExt($priceExt)
            ->setBVEach($bVEach)
            ->setBusinessVolume($businessVolume)
            ->setCVEach($cVEach)
            ->setCommissionableVolume($commissionableVolume)
            ->setDynamicKitItemID($dynamicKitItemID)
            ->setDescription($description)
            ->setReference1($reference1);
    }
    /**
     * Get AutoOrderID value
     * @return int
     */
    public function getAutoOrderID()
    {
        return $this->AutoOrderID;
    }
    /**
     * Set AutoOrderID value
     * @param int $autoOrderID
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setAutoOrderID($autoOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($autoOrderID) && !is_numeric($autoOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoOrderID)), __LINE__);
        }
        $this->AutoOrderID = $autoOrderID;
        return $this;
    }
    /**
     * Get OrderLine value
     * @return int
     */
    public function getOrderLine()
    {
        return $this->OrderLine;
    }
    /**
     * Set OrderLine value
     * @param int $orderLine
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setOrderLine($orderLine = null)
    {
        // validation for constraint: int
        if (!is_null($orderLine) && !is_numeric($orderLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderLine)), __LINE__);
        }
        $this->OrderLine = $orderLine;
        return $this;
    }
    /**
     * Get ItemID value
     * @return int
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param int $itemID
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: int
        if (!is_null($itemID) && !is_numeric($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setQty($qty = null)
    {
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get ManualPriceEach value
     * @return float
     */
    public function getManualPriceEach()
    {
        return $this->ManualPriceEach;
    }
    /**
     * Set ManualPriceEach value
     * @param float $manualPriceEach
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setManualPriceEach($manualPriceEach = null)
    {
        $this->ManualPriceEach = $manualPriceEach;
        return $this;
    }
    /**
     * Get ManualTaxablePriceEach value
     * @return float
     */
    public function getManualTaxablePriceEach()
    {
        return $this->ManualTaxablePriceEach;
    }
    /**
     * Set ManualTaxablePriceEach value
     * @param float $manualTaxablePriceEach
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setManualTaxablePriceEach($manualTaxablePriceEach = null)
    {
        $this->ManualTaxablePriceEach = $manualTaxablePriceEach;
        return $this;
    }
    /**
     * Get ManualShippingPriceEach value
     * @return float
     */
    public function getManualShippingPriceEach()
    {
        return $this->ManualShippingPriceEach;
    }
    /**
     * Set ManualShippingPriceEach value
     * @param float $manualShippingPriceEach
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setManualShippingPriceEach($manualShippingPriceEach = null)
    {
        $this->ManualShippingPriceEach = $manualShippingPriceEach;
        return $this;
    }
    /**
     * Get ManualBVEach value
     * @return float
     */
    public function getManualBVEach()
    {
        return $this->ManualBVEach;
    }
    /**
     * Set ManualBVEach value
     * @param float $manualBVEach
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setManualBVEach($manualBVEach = null)
    {
        $this->ManualBVEach = $manualBVEach;
        return $this;
    }
    /**
     * Get ManualCVEach value
     * @return float
     */
    public function getManualCVEach()
    {
        return $this->ManualCVEach;
    }
    /**
     * Set ManualCVEach value
     * @param float $manualCVEach
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setManualCVEach($manualCVEach = null)
    {
        $this->ManualCVEach = $manualCVEach;
        return $this;
    }
    /**
     * Get PeriodDescriptionTy value
     * @return int
     */
    public function getPeriodDescriptionTy()
    {
        return $this->PeriodDescriptionTy;
    }
    /**
     * Set PeriodDescriptionTy value
     * @param int $periodDescriptionTy
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setPeriodDescriptionTy($periodDescriptionTy = null)
    {
        // validation for constraint: int
        if (!is_null($periodDescriptionTy) && !is_numeric($periodDescriptionTy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodDescriptionTy)), __LINE__);
        }
        $this->PeriodDescriptionTy = $periodDescriptionTy;
        return $this;
    }
    /**
     * Get PriceEach value
     * @return float
     */
    public function getPriceEach()
    {
        return $this->PriceEach;
    }
    /**
     * Set PriceEach value
     * @param float $priceEach
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setPriceEach($priceEach = null)
    {
        $this->PriceEach = $priceEach;
        return $this;
    }
    /**
     * Get PriceExt value
     * @return float
     */
    public function getPriceExt()
    {
        return $this->PriceExt;
    }
    /**
     * Set PriceExt value
     * @param float $priceExt
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setPriceExt($priceExt = null)
    {
        $this->PriceExt = $priceExt;
        return $this;
    }
    /**
     * Get BVEach value
     * @return float
     */
    public function getBVEach()
    {
        return $this->BVEach;
    }
    /**
     * Set BVEach value
     * @param float $bVEach
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setBVEach($bVEach = null)
    {
        $this->BVEach = $bVEach;
        return $this;
    }
    /**
     * Get BusinessVolume value
     * @return float
     */
    public function getBusinessVolume()
    {
        return $this->BusinessVolume;
    }
    /**
     * Set BusinessVolume value
     * @param float $businessVolume
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setBusinessVolume($businessVolume = null)
    {
        $this->BusinessVolume = $businessVolume;
        return $this;
    }
    /**
     * Get CVEach value
     * @return float
     */
    public function getCVEach()
    {
        return $this->CVEach;
    }
    /**
     * Set CVEach value
     * @param float $cVEach
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setCVEach($cVEach = null)
    {
        $this->CVEach = $cVEach;
        return $this;
    }
    /**
     * Get CommissionableVolume value
     * @return float
     */
    public function getCommissionableVolume()
    {
        return $this->CommissionableVolume;
    }
    /**
     * Set CommissionableVolume value
     * @param float $commissionableVolume
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setCommissionableVolume($commissionableVolume = null)
    {
        $this->CommissionableVolume = $commissionableVolume;
        return $this;
    }
    /**
     * Get DynamicKitItemID value
     * @return int
     */
    public function getDynamicKitItemID()
    {
        return $this->DynamicKitItemID;
    }
    /**
     * Set DynamicKitItemID value
     * @param int $dynamicKitItemID
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setDynamicKitItemID($dynamicKitItemID = null)
    {
        // validation for constraint: int
        if (!is_null($dynamicKitItemID) && !is_numeric($dynamicKitItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dynamicKitItemID)), __LINE__);
        }
        $this->DynamicKitItemID = $dynamicKitItemID;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Reference1 value
     * @return string|null
     */
    public function getReference1()
    {
        return $this->Reference1;
    }
    /**
     * Set Reference1 value
     * @param string $reference1
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public function setReference1($reference1 = null)
    {
        // validation for constraint: string
        if (!is_null($reference1) && !is_string($reference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference1)), __LINE__);
        }
        $this->Reference1 = $reference1;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateAutoOrderDetailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
