<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StartSandboxRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:StartSandboxRequest
 * @subpackage Structs
 */
class StartSandboxRequest extends ApiRequest
{
    /**
     * The SandboxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SandboxID;
    /**
     * The EnableRevolvingCommissionRun
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EnableRevolvingCommissionRun;
    /**
     * The EnableBiSync
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EnableBiSync;
    /**
     * The UseRealTimeBackup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseRealTimeBackup;
    /**
     * The SyncFilterDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SyncFilterDays;
    /**
     * The SyncSettingsEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SyncSettingsEnable;
    /**
     * Constructor method for StartSandboxRequest
     * @uses StartSandboxRequest::setSandboxID()
     * @uses StartSandboxRequest::setEnableRevolvingCommissionRun()
     * @uses StartSandboxRequest::setEnableBiSync()
     * @uses StartSandboxRequest::setUseRealTimeBackup()
     * @uses StartSandboxRequest::setSyncFilterDays()
     * @uses StartSandboxRequest::setSyncSettingsEnable()
     * @param int $sandboxID
     * @param bool $enableRevolvingCommissionRun
     * @param bool $enableBiSync
     * @param bool $useRealTimeBackup
     * @param int $syncFilterDays
     * @param string $syncSettingsEnable
     */
    public function __construct($sandboxID = null, $enableRevolvingCommissionRun = null, $enableBiSync = null, $useRealTimeBackup = null, $syncFilterDays = null, $syncSettingsEnable = null)
    {
        $this
            ->setSandboxID($sandboxID)
            ->setEnableRevolvingCommissionRun($enableRevolvingCommissionRun)
            ->setEnableBiSync($enableBiSync)
            ->setUseRealTimeBackup($useRealTimeBackup)
            ->setSyncFilterDays($syncFilterDays)
            ->setSyncSettingsEnable($syncSettingsEnable);
    }
    /**
     * Get SandboxID value
     * @return int
     */
    public function getSandboxID()
    {
        return $this->SandboxID;
    }
    /**
     * Set SandboxID value
     * @param int $sandboxID
     * @return \StructType\StartSandboxRequest
     */
    public function setSandboxID($sandboxID = null)
    {
        // validation for constraint: int
        if (!is_null($sandboxID) && !is_numeric($sandboxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sandboxID)), __LINE__);
        }
        $this->SandboxID = $sandboxID;
        return $this;
    }
    /**
     * Get EnableRevolvingCommissionRun value
     * @return bool
     */
    public function getEnableRevolvingCommissionRun()
    {
        return $this->EnableRevolvingCommissionRun;
    }
    /**
     * Set EnableRevolvingCommissionRun value
     * @param bool $enableRevolvingCommissionRun
     * @return \StructType\StartSandboxRequest
     */
    public function setEnableRevolvingCommissionRun($enableRevolvingCommissionRun = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableRevolvingCommissionRun) && !is_bool($enableRevolvingCommissionRun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enableRevolvingCommissionRun)), __LINE__);
        }
        $this->EnableRevolvingCommissionRun = $enableRevolvingCommissionRun;
        return $this;
    }
    /**
     * Get EnableBiSync value
     * @return bool
     */
    public function getEnableBiSync()
    {
        return $this->EnableBiSync;
    }
    /**
     * Set EnableBiSync value
     * @param bool $enableBiSync
     * @return \StructType\StartSandboxRequest
     */
    public function setEnableBiSync($enableBiSync = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableBiSync) && !is_bool($enableBiSync)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enableBiSync)), __LINE__);
        }
        $this->EnableBiSync = $enableBiSync;
        return $this;
    }
    /**
     * Get UseRealTimeBackup value
     * @return bool
     */
    public function getUseRealTimeBackup()
    {
        return $this->UseRealTimeBackup;
    }
    /**
     * Set UseRealTimeBackup value
     * @param bool $useRealTimeBackup
     * @return \StructType\StartSandboxRequest
     */
    public function setUseRealTimeBackup($useRealTimeBackup = null)
    {
        // validation for constraint: boolean
        if (!is_null($useRealTimeBackup) && !is_bool($useRealTimeBackup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useRealTimeBackup)), __LINE__);
        }
        $this->UseRealTimeBackup = $useRealTimeBackup;
        return $this;
    }
    /**
     * Get SyncFilterDays value
     * @return int
     */
    public function getSyncFilterDays()
    {
        return $this->SyncFilterDays;
    }
    /**
     * Set SyncFilterDays value
     * @param int $syncFilterDays
     * @return \StructType\StartSandboxRequest
     */
    public function setSyncFilterDays($syncFilterDays = null)
    {
        // validation for constraint: int
        if (!is_null($syncFilterDays) && !is_numeric($syncFilterDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($syncFilterDays)), __LINE__);
        }
        $this->SyncFilterDays = $syncFilterDays;
        return $this;
    }
    /**
     * Get SyncSettingsEnable value
     * @return string|null
     */
    public function getSyncSettingsEnable()
    {
        return $this->SyncSettingsEnable;
    }
    /**
     * Set SyncSettingsEnable value
     * @param string $syncSettingsEnable
     * @return \StructType\StartSandboxRequest
     */
    public function setSyncSettingsEnable($syncSettingsEnable = null)
    {
        // validation for constraint: string
        if (!is_null($syncSettingsEnable) && !is_string($syncSettingsEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($syncSettingsEnable)), __LINE__);
        }
        $this->SyncSettingsEnable = $syncSettingsEnable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StartSandboxRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
