<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipMethodResponse StructType
 * @subpackage Structs
 */
class ShipMethodResponse extends AbstractStructBase
{
    /**
     * The ShipMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ShipMethodID;
    /**
     * The ShippingAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ShippingAmount;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for ShipMethodResponse
     * @uses ShipMethodResponse::setShipMethodID()
     * @uses ShipMethodResponse::setShippingAmount()
     * @uses ShipMethodResponse::setDescription()
     * @param int $shipMethodID
     * @param float $shippingAmount
     * @param string $description
     */
    public function __construct($shipMethodID = null, $shippingAmount = null, $description = null)
    {
        $this
            ->setShipMethodID($shipMethodID)
            ->setShippingAmount($shippingAmount)
            ->setDescription($description);
    }
    /**
     * Get ShipMethodID value
     * @return int
     */
    public function getShipMethodID()
    {
        return $this->ShipMethodID;
    }
    /**
     * Set ShipMethodID value
     * @param int $shipMethodID
     * @return \StructType\ShipMethodResponse
     */
    public function setShipMethodID($shipMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($shipMethodID) && !is_numeric($shipMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shipMethodID)), __LINE__);
        }
        $this->ShipMethodID = $shipMethodID;
        return $this;
    }
    /**
     * Get ShippingAmount value
     * @return float
     */
    public function getShippingAmount()
    {
        return $this->ShippingAmount;
    }
    /**
     * Set ShippingAmount value
     * @param float $shippingAmount
     * @return \StructType\ShipMethodResponse
     */
    public function setShippingAmount($shippingAmount = null)
    {
        $this->ShippingAmount = $shippingAmount;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ShipMethodResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipMethodResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
