<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetGuestSocialNetworksRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SetGuestSocialNetworksRequest
 * @subpackage Structs
 */
class SetGuestSocialNetworksRequest extends ApiRequest
{
    /**
     * The GuestID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GuestID;
    /**
     * The GuestSocialNetworks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuestSocialNetworkRequest
     */
    public $GuestSocialNetworks;
    /**
     * Constructor method for SetGuestSocialNetworksRequest
     * @uses SetGuestSocialNetworksRequest::setGuestID()
     * @uses SetGuestSocialNetworksRequest::setGuestSocialNetworks()
     * @param int $guestID
     * @param \ArrayType\ArrayOfGuestSocialNetworkRequest $guestSocialNetworks
     */
    public function __construct($guestID = null, \ArrayType\ArrayOfGuestSocialNetworkRequest $guestSocialNetworks = null)
    {
        $this
            ->setGuestID($guestID)
            ->setGuestSocialNetworks($guestSocialNetworks);
    }
    /**
     * Get GuestID value
     * @return int
     */
    public function getGuestID()
    {
        return $this->GuestID;
    }
    /**
     * Set GuestID value
     * @param int $guestID
     * @return \StructType\SetGuestSocialNetworksRequest
     */
    public function setGuestID($guestID = null)
    {
        // validation for constraint: int
        if (!is_null($guestID) && !is_numeric($guestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($guestID)), __LINE__);
        }
        $this->GuestID = $guestID;
        return $this;
    }
    /**
     * Get GuestSocialNetworks value
     * @return \ArrayType\ArrayOfGuestSocialNetworkRequest|null
     */
    public function getGuestSocialNetworks()
    {
        return $this->GuestSocialNetworks;
    }
    /**
     * Set GuestSocialNetworks value
     * @param \ArrayType\ArrayOfGuestSocialNetworkRequest $guestSocialNetworks
     * @return \StructType\SetGuestSocialNetworksRequest
     */
    public function setGuestSocialNetworks(\ArrayType\ArrayOfGuestSocialNetworkRequest $guestSocialNetworks = null)
    {
        $this->GuestSocialNetworks = $guestSocialNetworks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetGuestSocialNetworksRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
