<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetAccountCreditCardRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SetAccountCreditCardRequest
 * @subpackage Structs
 */
class SetAccountCreditCardRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CreditCardAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreditCardAccountType;
    /**
     * The ExpirationMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpirationMonth;
    /**
     * The ExpirationYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpirationYear;
    /**
     * The CreditCardType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CreditCardType;
    /**
     * The UseMainAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseMainAddress;
    /**
     * The HideFromWeb
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $HideFromWeb;
    /**
     * The CreditCardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardNumber;
    /**
     * The CvcCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CvcCode;
    /**
     * The IssueCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueCode;
    /**
     * The BillingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingName;
    /**
     * The BillingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress;
    /**
     * The BillingCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCity;
    /**
     * The BillingState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingState;
    /**
     * The BillingZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingZip;
    /**
     * The BillingCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCountry;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for SetAccountCreditCardRequest
     * @uses SetAccountCreditCardRequest::setCustomerID()
     * @uses SetAccountCreditCardRequest::setCreditCardAccountType()
     * @uses SetAccountCreditCardRequest::setExpirationMonth()
     * @uses SetAccountCreditCardRequest::setExpirationYear()
     * @uses SetAccountCreditCardRequest::setCreditCardType()
     * @uses SetAccountCreditCardRequest::setUseMainAddress()
     * @uses SetAccountCreditCardRequest::setHideFromWeb()
     * @uses SetAccountCreditCardRequest::setCreditCardNumber()
     * @uses SetAccountCreditCardRequest::setCvcCode()
     * @uses SetAccountCreditCardRequest::setIssueCode()
     * @uses SetAccountCreditCardRequest::setBillingName()
     * @uses SetAccountCreditCardRequest::setBillingAddress()
     * @uses SetAccountCreditCardRequest::setBillingCity()
     * @uses SetAccountCreditCardRequest::setBillingState()
     * @uses SetAccountCreditCardRequest::setBillingZip()
     * @uses SetAccountCreditCardRequest::setBillingCountry()
     * @uses SetAccountCreditCardRequest::setCustomerKey()
     * @param int $customerID
     * @param string $creditCardAccountType
     * @param int $expirationMonth
     * @param int $expirationYear
     * @param int $creditCardType
     * @param bool $useMainAddress
     * @param bool $hideFromWeb
     * @param string $creditCardNumber
     * @param string $cvcCode
     * @param string $issueCode
     * @param string $billingName
     * @param string $billingAddress
     * @param string $billingCity
     * @param string $billingState
     * @param string $billingZip
     * @param string $billingCountry
     * @param string $customerKey
     */
    public function __construct($customerID = null, $creditCardAccountType = null, $expirationMonth = null, $expirationYear = null, $creditCardType = null, $useMainAddress = null, $hideFromWeb = null, $creditCardNumber = null, $cvcCode = null, $issueCode = null, $billingName = null, $billingAddress = null, $billingCity = null, $billingState = null, $billingZip = null, $billingCountry = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setCreditCardAccountType($creditCardAccountType)
            ->setExpirationMonth($expirationMonth)
            ->setExpirationYear($expirationYear)
            ->setCreditCardType($creditCardType)
            ->setUseMainAddress($useMainAddress)
            ->setHideFromWeb($hideFromWeb)
            ->setCreditCardNumber($creditCardNumber)
            ->setCvcCode($cvcCode)
            ->setIssueCode($issueCode)
            ->setBillingName($billingName)
            ->setBillingAddress($billingAddress)
            ->setBillingCity($billingCity)
            ->setBillingState($billingState)
            ->setBillingZip($billingZip)
            ->setBillingCountry($billingCountry)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CreditCardAccountType value
     * @return string
     */
    public function getCreditCardAccountType()
    {
        return $this->CreditCardAccountType;
    }
    /**
     * Set CreditCardAccountType value
     * @uses \EnumType\AccountCreditCardType::valueIsValid()
     * @uses \EnumType\AccountCreditCardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creditCardAccountType
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setCreditCardAccountType($creditCardAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountCreditCardType::valueIsValid($creditCardAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $creditCardAccountType, implode(', ', \EnumType\AccountCreditCardType::getValidValues())), __LINE__);
        }
        $this->CreditCardAccountType = $creditCardAccountType;
        return $this;
    }
    /**
     * Get ExpirationMonth value
     * @return int
     */
    public function getExpirationMonth()
    {
        return $this->ExpirationMonth;
    }
    /**
     * Set ExpirationMonth value
     * @param int $expirationMonth
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setExpirationMonth($expirationMonth = null)
    {
        // validation for constraint: int
        if (!is_null($expirationMonth) && !is_numeric($expirationMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expirationMonth)), __LINE__);
        }
        $this->ExpirationMonth = $expirationMonth;
        return $this;
    }
    /**
     * Get ExpirationYear value
     * @return int
     */
    public function getExpirationYear()
    {
        return $this->ExpirationYear;
    }
    /**
     * Set ExpirationYear value
     * @param int $expirationYear
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setExpirationYear($expirationYear = null)
    {
        // validation for constraint: int
        if (!is_null($expirationYear) && !is_numeric($expirationYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expirationYear)), __LINE__);
        }
        $this->ExpirationYear = $expirationYear;
        return $this;
    }
    /**
     * Get CreditCardType value
     * @return int
     */
    public function getCreditCardType()
    {
        return $this->CreditCardType;
    }
    /**
     * Set CreditCardType value
     * @param int $creditCardType
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setCreditCardType($creditCardType = null)
    {
        // validation for constraint: int
        if (!is_null($creditCardType) && !is_numeric($creditCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($creditCardType)), __LINE__);
        }
        $this->CreditCardType = $creditCardType;
        return $this;
    }
    /**
     * Get UseMainAddress value
     * @return bool
     */
    public function getUseMainAddress()
    {
        return $this->UseMainAddress;
    }
    /**
     * Set UseMainAddress value
     * @param bool $useMainAddress
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setUseMainAddress($useMainAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($useMainAddress) && !is_bool($useMainAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useMainAddress)), __LINE__);
        }
        $this->UseMainAddress = $useMainAddress;
        return $this;
    }
    /**
     * Get HideFromWeb value
     * @return bool
     */
    public function getHideFromWeb()
    {
        return $this->HideFromWeb;
    }
    /**
     * Set HideFromWeb value
     * @param bool $hideFromWeb
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setHideFromWeb($hideFromWeb = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideFromWeb) && !is_bool($hideFromWeb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hideFromWeb)), __LINE__);
        }
        $this->HideFromWeb = $hideFromWeb;
        return $this;
    }
    /**
     * Get CreditCardNumber value
     * @return string|null
     */
    public function getCreditCardNumber()
    {
        return $this->CreditCardNumber;
    }
    /**
     * Set CreditCardNumber value
     * @param string $creditCardNumber
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setCreditCardNumber($creditCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardNumber) && !is_string($creditCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardNumber)), __LINE__);
        }
        $this->CreditCardNumber = $creditCardNumber;
        return $this;
    }
    /**
     * Get CvcCode value
     * @return string|null
     */
    public function getCvcCode()
    {
        return $this->CvcCode;
    }
    /**
     * Set CvcCode value
     * @param string $cvcCode
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setCvcCode($cvcCode = null)
    {
        // validation for constraint: string
        if (!is_null($cvcCode) && !is_string($cvcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cvcCode)), __LINE__);
        }
        $this->CvcCode = $cvcCode;
        return $this;
    }
    /**
     * Get IssueCode value
     * @return string|null
     */
    public function getIssueCode()
    {
        return $this->IssueCode;
    }
    /**
     * Set IssueCode value
     * @param string $issueCode
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setIssueCode($issueCode = null)
    {
        // validation for constraint: string
        if (!is_null($issueCode) && !is_string($issueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueCode)), __LINE__);
        }
        $this->IssueCode = $issueCode;
        return $this;
    }
    /**
     * Get BillingName value
     * @return string|null
     */
    public function getBillingName()
    {
        return $this->BillingName;
    }
    /**
     * Set BillingName value
     * @param string $billingName
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setBillingName($billingName = null)
    {
        // validation for constraint: string
        if (!is_null($billingName) && !is_string($billingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingName)), __LINE__);
        }
        $this->BillingName = $billingName;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return string|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param string $billingAddress
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setBillingAddress($billingAddress = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress) && !is_string($billingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress)), __LINE__);
        }
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get BillingCity value
     * @return string|null
     */
    public function getBillingCity()
    {
        return $this->BillingCity;
    }
    /**
     * Set BillingCity value
     * @param string $billingCity
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setBillingCity($billingCity = null)
    {
        // validation for constraint: string
        if (!is_null($billingCity) && !is_string($billingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCity)), __LINE__);
        }
        $this->BillingCity = $billingCity;
        return $this;
    }
    /**
     * Get BillingState value
     * @return string|null
     */
    public function getBillingState()
    {
        return $this->BillingState;
    }
    /**
     * Set BillingState value
     * @param string $billingState
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setBillingState($billingState = null)
    {
        // validation for constraint: string
        if (!is_null($billingState) && !is_string($billingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingState)), __LINE__);
        }
        $this->BillingState = $billingState;
        return $this;
    }
    /**
     * Get BillingZip value
     * @return string|null
     */
    public function getBillingZip()
    {
        return $this->BillingZip;
    }
    /**
     * Set BillingZip value
     * @param string $billingZip
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setBillingZip($billingZip = null)
    {
        // validation for constraint: string
        if (!is_null($billingZip) && !is_string($billingZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingZip)), __LINE__);
        }
        $this->BillingZip = $billingZip;
        return $this;
    }
    /**
     * Get BillingCountry value
     * @return string|null
     */
    public function getBillingCountry()
    {
        return $this->BillingCountry;
    }
    /**
     * Set BillingCountry value
     * @param string $billingCountry
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setBillingCountry($billingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($billingCountry) && !is_string($billingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCountry)), __LINE__);
        }
        $this->BillingCountry = $billingCountry;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\SetAccountCreditCardRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetAccountCreditCardRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
