<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sandbox StructType
 * @subpackage Structs
 */
class Sandbox extends AbstractStructBase
{
    /**
     * The CompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CompanyID;
    /**
     * The SandboxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SandboxID;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The PercentComplete
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PercentComplete;
    /**
     * The Hours
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Hours;
    /**
     * The AllowVolumePush
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowVolumePush;
    /**
     * The AllowBiSync
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowBiSync;
    /**
     * The SyncFilterDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SyncFilterDays;
    /**
     * The UseRealTimeBackup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseRealTimeBackup;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Sandbox
     * @uses Sandbox::setCompanyID()
     * @uses Sandbox::setSandboxID()
     * @uses Sandbox::setType()
     * @uses Sandbox::setStartDate()
     * @uses Sandbox::setPercentComplete()
     * @uses Sandbox::setHours()
     * @uses Sandbox::setAllowVolumePush()
     * @uses Sandbox::setAllowBiSync()
     * @uses Sandbox::setSyncFilterDays()
     * @uses Sandbox::setUseRealTimeBackup()
     * @uses Sandbox::setDescription()
     * @uses Sandbox::setStatus()
     * @param int $companyID
     * @param int $sandboxID
     * @param string $type
     * @param string $startDate
     * @param float $percentComplete
     * @param float $hours
     * @param bool $allowVolumePush
     * @param bool $allowBiSync
     * @param int $syncFilterDays
     * @param bool $useRealTimeBackup
     * @param string $description
     * @param string $status
     */
    public function __construct($companyID = null, $sandboxID = null, $type = null, $startDate = null, $percentComplete = null, $hours = null, $allowVolumePush = null, $allowBiSync = null, $syncFilterDays = null, $useRealTimeBackup = null, $description = null, $status = null)
    {
        $this
            ->setCompanyID($companyID)
            ->setSandboxID($sandboxID)
            ->setType($type)
            ->setStartDate($startDate)
            ->setPercentComplete($percentComplete)
            ->setHours($hours)
            ->setAllowVolumePush($allowVolumePush)
            ->setAllowBiSync($allowBiSync)
            ->setSyncFilterDays($syncFilterDays)
            ->setUseRealTimeBackup($useRealTimeBackup)
            ->setDescription($description)
            ->setStatus($status);
    }
    /**
     * Get CompanyID value
     * @return int
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \StructType\Sandbox
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !is_numeric($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get SandboxID value
     * @return int
     */
    public function getSandboxID()
    {
        return $this->SandboxID;
    }
    /**
     * Set SandboxID value
     * @param int $sandboxID
     * @return \StructType\Sandbox
     */
    public function setSandboxID($sandboxID = null)
    {
        // validation for constraint: int
        if (!is_null($sandboxID) && !is_numeric($sandboxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sandboxID)), __LINE__);
        }
        $this->SandboxID = $sandboxID;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\SandboxType::valueIsValid()
     * @uses \EnumType\SandboxType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Sandbox
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SandboxType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\SandboxType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\Sandbox
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get PercentComplete value
     * @return float
     */
    public function getPercentComplete()
    {
        return $this->PercentComplete;
    }
    /**
     * Set PercentComplete value
     * @param float $percentComplete
     * @return \StructType\Sandbox
     */
    public function setPercentComplete($percentComplete = null)
    {
        $this->PercentComplete = $percentComplete;
        return $this;
    }
    /**
     * Get Hours value
     * @return float
     */
    public function getHours()
    {
        return $this->Hours;
    }
    /**
     * Set Hours value
     * @param float $hours
     * @return \StructType\Sandbox
     */
    public function setHours($hours = null)
    {
        $this->Hours = $hours;
        return $this;
    }
    /**
     * Get AllowVolumePush value
     * @return bool
     */
    public function getAllowVolumePush()
    {
        return $this->AllowVolumePush;
    }
    /**
     * Set AllowVolumePush value
     * @param bool $allowVolumePush
     * @return \StructType\Sandbox
     */
    public function setAllowVolumePush($allowVolumePush = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowVolumePush) && !is_bool($allowVolumePush)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowVolumePush)), __LINE__);
        }
        $this->AllowVolumePush = $allowVolumePush;
        return $this;
    }
    /**
     * Get AllowBiSync value
     * @return bool
     */
    public function getAllowBiSync()
    {
        return $this->AllowBiSync;
    }
    /**
     * Set AllowBiSync value
     * @param bool $allowBiSync
     * @return \StructType\Sandbox
     */
    public function setAllowBiSync($allowBiSync = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowBiSync) && !is_bool($allowBiSync)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowBiSync)), __LINE__);
        }
        $this->AllowBiSync = $allowBiSync;
        return $this;
    }
    /**
     * Get SyncFilterDays value
     * @return int
     */
    public function getSyncFilterDays()
    {
        return $this->SyncFilterDays;
    }
    /**
     * Set SyncFilterDays value
     * @param int $syncFilterDays
     * @return \StructType\Sandbox
     */
    public function setSyncFilterDays($syncFilterDays = null)
    {
        // validation for constraint: int
        if (!is_null($syncFilterDays) && !is_numeric($syncFilterDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($syncFilterDays)), __LINE__);
        }
        $this->SyncFilterDays = $syncFilterDays;
        return $this;
    }
    /**
     * Get UseRealTimeBackup value
     * @return bool
     */
    public function getUseRealTimeBackup()
    {
        return $this->UseRealTimeBackup;
    }
    /**
     * Set UseRealTimeBackup value
     * @param bool $useRealTimeBackup
     * @return \StructType\Sandbox
     */
    public function setUseRealTimeBackup($useRealTimeBackup = null)
    {
        // validation for constraint: boolean
        if (!is_null($useRealTimeBackup) && !is_bool($useRealTimeBackup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useRealTimeBackup)), __LINE__);
        }
        $this->UseRealTimeBackup = $useRealTimeBackup;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Sandbox
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\Sandbox
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Sandbox
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
