<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportParameterRequest StructType
 * @subpackage Structs
 */
class ReportParameterRequest extends AbstractStructBase
{
    /**
     * The ParameterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParameterName;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for ReportParameterRequest
     * @uses ReportParameterRequest::setParameterName()
     * @uses ReportParameterRequest::setValue()
     * @param string $parameterName
     * @param string $value
     */
    public function __construct($parameterName = null, $value = null)
    {
        $this
            ->setParameterName($parameterName)
            ->setValue($value);
    }
    /**
     * Get ParameterName value
     * @return string|null
     */
    public function getParameterName()
    {
        return $this->ParameterName;
    }
    /**
     * Set ParameterName value
     * @param string $parameterName
     * @return \StructType\ReportParameterRequest
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parameterName)), __LINE__);
        }
        $this->ParameterName = $parameterName;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\ReportParameterRequest
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportParameterRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
