<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QualificationResponse StructType
 * @subpackage Structs
 */
class QualificationResponse extends AbstractStructBase
{
    /**
     * The Qualifies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Qualifies;
    /**
     * The QualifiesOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $QualifiesOverride;
    /**
     * The Completed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Completed;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Weight;
    /**
     * The Score
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Score;
    /**
     * The QualificationDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QualificationDescription;
    /**
     * The Required
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Required;
    /**
     * The Actual
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Actual;
    /**
     * The SupportingTable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SupportingTable
     */
    public $SupportingTable;
    /**
     * Constructor method for QualificationResponse
     * @uses QualificationResponse::setQualifies()
     * @uses QualificationResponse::setQualifiesOverride()
     * @uses QualificationResponse::setCompleted()
     * @uses QualificationResponse::setWeight()
     * @uses QualificationResponse::setScore()
     * @uses QualificationResponse::setQualificationDescription()
     * @uses QualificationResponse::setRequired()
     * @uses QualificationResponse::setActual()
     * @uses QualificationResponse::setSupportingTable()
     * @param bool $qualifies
     * @param bool $qualifiesOverride
     * @param float $completed
     * @param float $weight
     * @param float $score
     * @param string $qualificationDescription
     * @param string $required
     * @param string $actual
     * @param \StructType\SupportingTable $supportingTable
     */
    public function __construct($qualifies = null, $qualifiesOverride = null, $completed = null, $weight = null, $score = null, $qualificationDescription = null, $required = null, $actual = null, \StructType\SupportingTable $supportingTable = null)
    {
        $this
            ->setQualifies($qualifies)
            ->setQualifiesOverride($qualifiesOverride)
            ->setCompleted($completed)
            ->setWeight($weight)
            ->setScore($score)
            ->setQualificationDescription($qualificationDescription)
            ->setRequired($required)
            ->setActual($actual)
            ->setSupportingTable($supportingTable);
    }
    /**
     * Get Qualifies value
     * @return bool
     */
    public function getQualifies()
    {
        return $this->Qualifies;
    }
    /**
     * Set Qualifies value
     * @param bool $qualifies
     * @return \StructType\QualificationResponse
     */
    public function setQualifies($qualifies = null)
    {
        // validation for constraint: boolean
        if (!is_null($qualifies) && !is_bool($qualifies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($qualifies)), __LINE__);
        }
        $this->Qualifies = $qualifies;
        return $this;
    }
    /**
     * Get QualifiesOverride value
     * @return bool
     */
    public function getQualifiesOverride()
    {
        return $this->QualifiesOverride;
    }
    /**
     * Set QualifiesOverride value
     * @param bool $qualifiesOverride
     * @return \StructType\QualificationResponse
     */
    public function setQualifiesOverride($qualifiesOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($qualifiesOverride) && !is_bool($qualifiesOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($qualifiesOverride)), __LINE__);
        }
        $this->QualifiesOverride = $qualifiesOverride;
        return $this;
    }
    /**
     * Get Completed value
     * @return float
     */
    public function getCompleted()
    {
        return $this->Completed;
    }
    /**
     * Set Completed value
     * @param float $completed
     * @return \StructType\QualificationResponse
     */
    public function setCompleted($completed = null)
    {
        $this->Completed = $completed;
        return $this;
    }
    /**
     * Get Weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \StructType\QualificationResponse
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Score value
     * @return float
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param float $score
     * @return \StructType\QualificationResponse
     */
    public function setScore($score = null)
    {
        $this->Score = $score;
        return $this;
    }
    /**
     * Get QualificationDescription value
     * @return string|null
     */
    public function getQualificationDescription()
    {
        return $this->QualificationDescription;
    }
    /**
     * Set QualificationDescription value
     * @param string $qualificationDescription
     * @return \StructType\QualificationResponse
     */
    public function setQualificationDescription($qualificationDescription = null)
    {
        // validation for constraint: string
        if (!is_null($qualificationDescription) && !is_string($qualificationDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qualificationDescription)), __LINE__);
        }
        $this->QualificationDescription = $qualificationDescription;
        return $this;
    }
    /**
     * Get Required value
     * @return string|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param string $required
     * @return \StructType\QualificationResponse
     */
    public function setRequired($required = null)
    {
        // validation for constraint: string
        if (!is_null($required) && !is_string($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Get Actual value
     * @return string|null
     */
    public function getActual()
    {
        return $this->Actual;
    }
    /**
     * Set Actual value
     * @param string $actual
     * @return \StructType\QualificationResponse
     */
    public function setActual($actual = null)
    {
        // validation for constraint: string
        if (!is_null($actual) && !is_string($actual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actual)), __LINE__);
        }
        $this->Actual = $actual;
        return $this;
    }
    /**
     * Get SupportingTable value
     * @return \StructType\SupportingTable|null
     */
    public function getSupportingTable()
    {
        return $this->SupportingTable;
    }
    /**
     * Set SupportingTable value
     * @param \StructType\SupportingTable $supportingTable
     * @return \StructType\QualificationResponse
     */
    public function setSupportingTable(\StructType\SupportingTable $supportingTable = null)
    {
        $this->SupportingTable = $supportingTable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QualificationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
