<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Property StructType
 * @subpackage Structs
 */
class Property extends AbstractStructBase
{
    /**
     * The IsKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsKey;
    /**
     * The IsNew
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNew;
    /**
     * The IsAutoNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAutoNumber;
    /**
     * The AllowDbNull
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowDbNull;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Size
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Size;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The DefaultName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultName;
    /**
     * The DefaultValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultValue;
    /**
     * Constructor method for Property
     * @uses Property::setIsKey()
     * @uses Property::setIsNew()
     * @uses Property::setIsAutoNumber()
     * @uses Property::setAllowDbNull()
     * @uses Property::setType()
     * @uses Property::setSize()
     * @uses Property::setName()
     * @uses Property::setDefaultName()
     * @uses Property::setDefaultValue()
     * @param bool $isKey
     * @param bool $isNew
     * @param bool $isAutoNumber
     * @param bool $allowDbNull
     * @param string $type
     * @param int $size
     * @param string $name
     * @param string $defaultName
     * @param string $defaultValue
     */
    public function __construct($isKey = null, $isNew = null, $isAutoNumber = null, $allowDbNull = null, $type = null, $size = null, $name = null, $defaultName = null, $defaultValue = null)
    {
        $this
            ->setIsKey($isKey)
            ->setIsNew($isNew)
            ->setIsAutoNumber($isAutoNumber)
            ->setAllowDbNull($allowDbNull)
            ->setType($type)
            ->setSize($size)
            ->setName($name)
            ->setDefaultName($defaultName)
            ->setDefaultValue($defaultValue);
    }
    /**
     * Get IsKey value
     * @return bool
     */
    public function getIsKey()
    {
        return $this->IsKey;
    }
    /**
     * Set IsKey value
     * @param bool $isKey
     * @return \StructType\Property
     */
    public function setIsKey($isKey = null)
    {
        // validation for constraint: boolean
        if (!is_null($isKey) && !is_bool($isKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isKey)), __LINE__);
        }
        $this->IsKey = $isKey;
        return $this;
    }
    /**
     * Get IsNew value
     * @return bool
     */
    public function getIsNew()
    {
        return $this->IsNew;
    }
    /**
     * Set IsNew value
     * @param bool $isNew
     * @return \StructType\Property
     */
    public function setIsNew($isNew = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNew) && !is_bool($isNew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isNew)), __LINE__);
        }
        $this->IsNew = $isNew;
        return $this;
    }
    /**
     * Get IsAutoNumber value
     * @return bool
     */
    public function getIsAutoNumber()
    {
        return $this->IsAutoNumber;
    }
    /**
     * Set IsAutoNumber value
     * @param bool $isAutoNumber
     * @return \StructType\Property
     */
    public function setIsAutoNumber($isAutoNumber = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoNumber) && !is_bool($isAutoNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAutoNumber)), __LINE__);
        }
        $this->IsAutoNumber = $isAutoNumber;
        return $this;
    }
    /**
     * Get AllowDbNull value
     * @return bool
     */
    public function getAllowDbNull()
    {
        return $this->AllowDbNull;
    }
    /**
     * Set AllowDbNull value
     * @param bool $allowDbNull
     * @return \StructType\Property
     */
    public function setAllowDbNull($allowDbNull = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowDbNull) && !is_bool($allowDbNull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowDbNull)), __LINE__);
        }
        $this->AllowDbNull = $allowDbNull;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\PropertyType::valueIsValid()
     * @uses \EnumType\PropertyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Property
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PropertyType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\PropertyType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Size value
     * @return int
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param int $size
     * @return \StructType\Property
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !is_numeric($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Property
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get DefaultName value
     * @return string|null
     */
    public function getDefaultName()
    {
        return $this->DefaultName;
    }
    /**
     * Set DefaultName value
     * @param string $defaultName
     * @return \StructType\Property
     */
    public function setDefaultName($defaultName = null)
    {
        // validation for constraint: string
        if (!is_null($defaultName) && !is_string($defaultName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultName)), __LINE__);
        }
        $this->DefaultName = $defaultName;
        return $this;
    }
    /**
     * Get DefaultValue value
     * @return string|null
     */
    public function getDefaultValue()
    {
        return $this->DefaultValue;
    }
    /**
     * Set DefaultValue value
     * @param string $defaultValue
     * @return \StructType\Property
     */
    public function setDefaultValue($defaultValue = null)
    {
        // validation for constraint: string
        if (!is_null($defaultValue) && !is_string($defaultValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultValue)), __LINE__);
        }
        $this->DefaultValue = $defaultValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Property
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
