<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceUniLevelNodeRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:PlaceUniLevelNodeRequest
 * @subpackage Structs
 */
class PlaceUniLevelNodeRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The ToSponsorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ToSponsorID;
    /**
     * The OptionalPlacement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OptionalPlacement;
    /**
     * The OptionalFindAvailable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OptionalFindAvailable;
    /**
     * The OptionalUnilevelBuildTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OptionalUnilevelBuildTypeID;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * The ToSponsorKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToSponsorKey;
    /**
     * Constructor method for PlaceUniLevelNodeRequest
     * @uses PlaceUniLevelNodeRequest::setCustomerID()
     * @uses PlaceUniLevelNodeRequest::setToSponsorID()
     * @uses PlaceUniLevelNodeRequest::setOptionalPlacement()
     * @uses PlaceUniLevelNodeRequest::setOptionalFindAvailable()
     * @uses PlaceUniLevelNodeRequest::setOptionalUnilevelBuildTypeID()
     * @uses PlaceUniLevelNodeRequest::setReason()
     * @uses PlaceUniLevelNodeRequest::setCustomerKey()
     * @uses PlaceUniLevelNodeRequest::setToSponsorKey()
     * @param int $customerID
     * @param int $toSponsorID
     * @param int $optionalPlacement
     * @param bool $optionalFindAvailable
     * @param int $optionalUnilevelBuildTypeID
     * @param string $reason
     * @param string $customerKey
     * @param string $toSponsorKey
     */
    public function __construct($customerID = null, $toSponsorID = null, $optionalPlacement = null, $optionalFindAvailable = null, $optionalUnilevelBuildTypeID = null, $reason = null, $customerKey = null, $toSponsorKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setToSponsorID($toSponsorID)
            ->setOptionalPlacement($optionalPlacement)
            ->setOptionalFindAvailable($optionalFindAvailable)
            ->setOptionalUnilevelBuildTypeID($optionalUnilevelBuildTypeID)
            ->setReason($reason)
            ->setCustomerKey($customerKey)
            ->setToSponsorKey($toSponsorKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\PlaceUniLevelNodeRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get ToSponsorID value
     * @return int
     */
    public function getToSponsorID()
    {
        return $this->ToSponsorID;
    }
    /**
     * Set ToSponsorID value
     * @param int $toSponsorID
     * @return \StructType\PlaceUniLevelNodeRequest
     */
    public function setToSponsorID($toSponsorID = null)
    {
        // validation for constraint: int
        if (!is_null($toSponsorID) && !is_numeric($toSponsorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toSponsorID)), __LINE__);
        }
        $this->ToSponsorID = $toSponsorID;
        return $this;
    }
    /**
     * Get OptionalPlacement value
     * @return int
     */
    public function getOptionalPlacement()
    {
        return $this->OptionalPlacement;
    }
    /**
     * Set OptionalPlacement value
     * @param int $optionalPlacement
     * @return \StructType\PlaceUniLevelNodeRequest
     */
    public function setOptionalPlacement($optionalPlacement = null)
    {
        // validation for constraint: int
        if (!is_null($optionalPlacement) && !is_numeric($optionalPlacement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($optionalPlacement)), __LINE__);
        }
        $this->OptionalPlacement = $optionalPlacement;
        return $this;
    }
    /**
     * Get OptionalFindAvailable value
     * @return bool
     */
    public function getOptionalFindAvailable()
    {
        return $this->OptionalFindAvailable;
    }
    /**
     * Set OptionalFindAvailable value
     * @param bool $optionalFindAvailable
     * @return \StructType\PlaceUniLevelNodeRequest
     */
    public function setOptionalFindAvailable($optionalFindAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionalFindAvailable) && !is_bool($optionalFindAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($optionalFindAvailable)), __LINE__);
        }
        $this->OptionalFindAvailable = $optionalFindAvailable;
        return $this;
    }
    /**
     * Get OptionalUnilevelBuildTypeID value
     * @return int
     */
    public function getOptionalUnilevelBuildTypeID()
    {
        return $this->OptionalUnilevelBuildTypeID;
    }
    /**
     * Set OptionalUnilevelBuildTypeID value
     * @param int $optionalUnilevelBuildTypeID
     * @return \StructType\PlaceUniLevelNodeRequest
     */
    public function setOptionalUnilevelBuildTypeID($optionalUnilevelBuildTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($optionalUnilevelBuildTypeID) && !is_numeric($optionalUnilevelBuildTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($optionalUnilevelBuildTypeID)), __LINE__);
        }
        $this->OptionalUnilevelBuildTypeID = $optionalUnilevelBuildTypeID;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\PlaceUniLevelNodeRequest
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\PlaceUniLevelNodeRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get ToSponsorKey value
     * @return string|null
     */
    public function getToSponsorKey()
    {
        return $this->ToSponsorKey;
    }
    /**
     * Set ToSponsorKey value
     * @param string $toSponsorKey
     * @return \StructType\PlaceUniLevelNodeRequest
     */
    public function setToSponsorKey($toSponsorKey = null)
    {
        // validation for constraint: string
        if (!is_null($toSponsorKey) && !is_string($toSponsorKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toSponsorKey)), __LINE__);
        }
        $this->ToSponsorKey = $toSponsorKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceUniLevelNodeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
