<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceStackNodeRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:PlaceStackNodeRequest
 * @subpackage Structs
 */
class PlaceStackNodeRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The ToParentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ToParentID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * The ToParentKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToParentKey;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * Constructor method for PlaceStackNodeRequest
     * @uses PlaceStackNodeRequest::setCustomerID()
     * @uses PlaceStackNodeRequest::setToParentID()
     * @uses PlaceStackNodeRequest::setCustomerKey()
     * @uses PlaceStackNodeRequest::setToParentKey()
     * @uses PlaceStackNodeRequest::setReason()
     * @param int $customerID
     * @param int $toParentID
     * @param string $customerKey
     * @param string $toParentKey
     * @param string $reason
     */
    public function __construct($customerID = null, $toParentID = null, $customerKey = null, $toParentKey = null, $reason = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setToParentID($toParentID)
            ->setCustomerKey($customerKey)
            ->setToParentKey($toParentKey)
            ->setReason($reason);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\PlaceStackNodeRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get ToParentID value
     * @return int
     */
    public function getToParentID()
    {
        return $this->ToParentID;
    }
    /**
     * Set ToParentID value
     * @param int $toParentID
     * @return \StructType\PlaceStackNodeRequest
     */
    public function setToParentID($toParentID = null)
    {
        // validation for constraint: int
        if (!is_null($toParentID) && !is_numeric($toParentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toParentID)), __LINE__);
        }
        $this->ToParentID = $toParentID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\PlaceStackNodeRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get ToParentKey value
     * @return string|null
     */
    public function getToParentKey()
    {
        return $this->ToParentKey;
    }
    /**
     * Set ToParentKey value
     * @param string $toParentKey
     * @return \StructType\PlaceStackNodeRequest
     */
    public function setToParentKey($toParentKey = null)
    {
        // validation for constraint: string
        if (!is_null($toParentKey) && !is_string($toParentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toParentKey)), __LINE__);
        }
        $this->ToParentKey = $toParentKey;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\PlaceStackNodeRequest
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceStackNodeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
